/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_spawner.content.components.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.oierbravo.create_mechanical_spawner.ModConstants;
import com.oierbravo.create_mechanical_spawner.content.components.recipe.SpawnerRecipe;
import com.oierbravo.create_mechanical_spawner.content.components.recipe.SpawnerRecipeBuilder;
import com.oierbravo.mechanicals.foundation.recipe.AbstractMechanicalRecipe;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeRequirement;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.List;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.common.conditions.ICondition;

public class SpawnerRecipeSerializer
implements RecipeSerializer<SpawnerRecipe> {
    public static final SpawnerRecipeSerializer INSTANCE = new SpawnerRecipeSerializer();
    public final StreamCodec<RegistryFriendlyByteBuf, SpawnerRecipe> STREAM_CODEC = StreamCodec.of(this::toNetwork, this::fromNetwork);
    public static final MapCodec<SpawnerRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidIngredient.CODEC.fieldOf("input").forGetter(SpawnerRecipe::getInput), (App)ResourceLocation.CODEC.optionalFieldOf("output", (Object)ModConstants.asResource("random")).forGetter(SpawnerRecipe::getMobResourceLocation), (App)NonNullList.codecOf((Codec)ProcessingOutput.CODEC_NEW).optionalFieldOf("customLoot", (Object)NonNullList.create()).forGetter(SpawnerRecipe::getCustomLoot), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("processingTime", (Object)0).forGetter(SpawnerRecipe::getProcessingTime), (App)IRecipeRequirement.LIST_CODEC.optionalFieldOf("requirements", List.of()).forGetter(SpawnerRecipe::getRecipeRequirements), (App)ICondition.LIST_CODEC.optionalFieldOf("neoforge:conditions", List.of()).forGetter(AbstractMechanicalRecipe::getConditions)).apply((Applicative)instance, (input, output, customLoot, processingTime, requirements, iConditions) -> ((SpawnerRecipeBuilder)((SpawnerRecipeBuilder)new SpawnerRecipeBuilder().require((FluidIngredient)input).output((ResourceLocation)output).processingTime((int)processingTime).withCustomLoot((NonNullList<ProcessingOutput>)customLoot).withRequirements((List)requirements)).withConditions((List)iConditions)).build()));

    private SpawnerRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        FluidIngredient input = (FluidIngredient)FluidIngredient.STREAM_CODEC.decode((Object)buffer);
        ResourceLocation output = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buffer);
        NonNullList customLoot = (NonNullList)CatnipStreamCodecBuilders.nonNullList((StreamCodec)ProcessingOutput.STREAM_CODEC).decode((Object)buffer);
        int processingTime = (Integer)ByteBufCodecs.VAR_INT.decode((Object)buffer);
        List recipeRequirements = (List)IRecipeRequirement.LIST_STREAM_CODEC.decode((Object)buffer);
        return ((SpawnerRecipeBuilder)new SpawnerRecipeBuilder().require(input).output(output).withCustomLoot((NonNullList<ProcessingOutput>)customLoot).processingTime(processingTime).withRequirements(recipeRequirements)).build();
    }

    private void toNetwork(RegistryFriendlyByteBuf buffer, SpawnerRecipe spawnerRecipe) {
        FluidIngredient.STREAM_CODEC.encode((Object)buffer, (Object)spawnerRecipe.getFluidIngredient());
        ResourceLocation.STREAM_CODEC.encode((Object)buffer, (Object)spawnerRecipe.getMobResourceLocation());
        CatnipStreamCodecBuilders.nonNullList((StreamCodec)ProcessingOutput.STREAM_CODEC).encode((Object)buffer, spawnerRecipe.getCustomLoot());
        ByteBufCodecs.VAR_INT.encode((Object)buffer, (Object)spawnerRecipe.getProcessingTime());
        IRecipeRequirement.LIST_STREAM_CODEC.encode((Object)buffer, spawnerRecipe.getRecipeRequirements());
    }

    public MapCodec<SpawnerRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, SpawnerRecipe> streamCodec() {
        return this.STREAM_CODEC;
    }
}

