/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_spawner.foundation.utility;

import com.oierbravo.create_mechanical_spawner.CreateMechanicalSpawner;
import com.simibubi.create.content.kinetics.deployer.DeployerFakePlayer;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class LivingEntityHelper {
    public static void spawnLivingEntity(Level level, ResourceKey<EntityType<?>> entityKey, BlockPos pos) {
        Entity entitySpawn;
        if (level.isClientSide) {
            return;
        }
        if (entityKey == null) {
            LivingEntityHelper.spawnRandomLivingEntity(level, pos);
            return;
        }
        EntityType entity = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityKey);
        try {
            entitySpawn = entity.create(level);
        }
        catch (Exception exception) {
            CreateMechanicalSpawner.LOGGER.warn("Failed to create mob", (Throwable)exception);
            return;
        }
        assert (entitySpawn != null);
        entitySpawn.moveTo((double)pos.getX() + 0.51, (double)pos.getY(), (double)pos.getZ() + 0.51, level.getRandom().nextFloat() * 360.0f, 0.0f);
        if (!(entitySpawn instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entitySpawn;
        if (mob.checkSpawnObstruction((LevelReader)level)) {
            level.addFreshEntity((Entity)mob);
        }
    }

    public static void spawnRandomLivingEntity(Level level, BlockPos pos) {
        Optional spawn = ((Biome)level.getBiome(pos).value()).getMobSettings().getMobs(MobCategory.MONSTER).getRandom(level.getRandom());
        if (spawn.isPresent()) {
            Entity entity;
            Object spawngroupdata = null;
            try {
                entity = ((MobSpawnSettings.SpawnerData)spawn.get()).type.create(level);
            }
            catch (Exception exception) {
                CreateMechanicalSpawner.LOGGER.warn("Failed to create mob", (Throwable)exception);
                return;
            }
            assert (entity != null);
            entity.moveTo((double)pos.getX() + 0.51, (double)pos.getY(), (double)pos.getZ() + 0.51, level.getRandom().nextFloat() * 360.0f, 0.0f);
            if (!(entity instanceof Mob)) {
                return;
            }
            Mob mob = (Mob)entity;
            if (mob.checkSpawnObstruction((LevelReader)level)) {
                level.addFreshEntity((Entity)mob);
            }
        }
    }

    public static Entity createEntity(ServerLevel pLevel, ResourceKey<EntityType<?>> pEntityKey, BlockPos pPos) {
        if (pEntityKey == null) {
            return LivingEntityHelper.createRandomEntity(pLevel, pPos);
        }
        EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(pEntityKey);
        try {
            return entityType.create((Level)pLevel);
        }
        catch (Exception exception) {
            CreateMechanicalSpawner.LOGGER.warn("Failed to create mob", (Throwable)exception);
            return null;
        }
    }

    private static Entity createRandomEntity(ServerLevel pLevel, BlockPos pPos) {
        Optional spawn = ((Biome)pLevel.getBiome(pPos).value()).getMobSettings().getMobs(MobCategory.MONSTER).getRandom(pLevel.getRandom());
        try {
            return ((MobSpawnSettings.SpawnerData)spawn.get()).type.create((Level)pLevel);
        }
        catch (Exception exception) {
            CreateMechanicalSpawner.LOGGER.warn("Failed to create random mob", (Throwable)exception);
            return null;
        }
    }

    public static List<ItemStack> getLootFromMob(ServerLevel pLevel, Entity entity, BlockPos pSpawnPos, DeployerFakePlayer pFakePlayer, int lootingLevel) {
        if (!(entity instanceof Mob)) {
            return List.of();
        }
        Mob mob = (Mob)entity;
        ResourceLocation resourceLocation = mob.getLootTable().location();
        ResourceKey lootTableKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)resourceLocation);
        DeployerFakePlayer fakePlayer = new DeployerFakePlayer(pLevel, pFakePlayer.getUUID());
        ItemStack fakeSword = new ItemStack((ItemLike)Items.DIAMOND_SWORD);
        if (lootingLevel > 0) {
            fakeSword.enchant(pLevel.holderOrThrow(Enchantments.LOOTING), lootingLevel);
        }
        fakePlayer.getInventory().add(fakePlayer.getInventory().selected, fakeSword);
        DamageSource damageSource = pLevel.damageSources().playerAttack((Player)fakePlayer);
        LootParams.Builder builder = new LootParams.Builder(pLevel);
        builder.withParameter(LootContextParams.ORIGIN, (Object)pSpawnPos.getCenter());
        builder.withLuck(3.0f).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)damageSource).withParameter(LootContextParams.TOOL, (Object)fakeSword).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)fakePlayer).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)damageSource.getDirectEntity());
        builder = builder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)fakePlayer);
        LootParams params = builder.create(LootContextParamSet.builder().build());
        LootTable table = pLevel.getServer().reloadableRegistries().getLootTable(lootTableKey);
        return table.getRandomItems(params);
    }
}

