/*
 * Decompiled with CFR 0.152.
 */
package de.fabenet.createnj.item;

import com.google.common.collect.Iterables;
import de.fabenet.createnj.client.model.Modelbrass_jetpack;
import de.fabenet.createnj.init.CreateNjModItems;
import de.fabenet.createnj.procedures.JetpackTickEventProcedure;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public abstract class NetheriteJetpackItem
extends ArmorItem {
    public static Holder<ArmorMaterial> ARMOR_MATERIAL = null;

    @SubscribeEvent
    public static void registerArmorMaterial(RegisterEvent event) {
        event.register(Registries.ARMOR_MATERIAL, registerHelper -> {
            ArmorMaterial armorMaterial = new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
                map.put(ArmorItem.Type.BOOTS, 0);
                map.put(ArmorItem.Type.LEGGINGS, 0);
                map.put(ArmorItem.Type.CHESTPLATE, 8);
                map.put(ArmorItem.Type.HELMET, 0);
                map.put(ArmorItem.Type.BODY, 8);
            }), 15, (Holder)DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)ResourceLocation.parse((String)"item.armor.equip_netherite")), () -> Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.NETHERITE_INGOT)}), List.of(new ArmorMaterial.Layer(ResourceLocation.parse((String)"create_nj:netherite_"))), 3.0f, 0.1f);
            registerHelper.register(ResourceLocation.parse((String)"create_nj:netherite_jetpack"), (Object)armorMaterial);
            ARMOR_MATERIAL = BuiltInRegistries.ARMOR_MATERIAL.wrapAsHolder((Object)armorMaterial);
        });
    }

    @SubscribeEvent
    public static void registerItemExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            @OnlyIn(value=Dist.CLIENT)
            public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("body", new Modelbrass_jetpack<T>((ModelPart)Minecraft.getInstance().getEntityModels().bakeLayer((ModelLayerLocation)Modelbrass_jetpack.LAYER_LOCATION)).body, "left_arm", new Modelbrass_jetpack<T>((ModelPart)Minecraft.getInstance().getEntityModels().bakeLayer((ModelLayerLocation)Modelbrass_jetpack.LAYER_LOCATION)).leftarm, "right_arm", new Modelbrass_jetpack<T>((ModelPart)Minecraft.getInstance().getEntityModels().bakeLayer((ModelLayerLocation)Modelbrass_jetpack.LAYER_LOCATION)).rightarm, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                armorModel.crouching = living.isShiftKeyDown();
                armorModel.riding = defaultModel.riding;
                armorModel.young = living.isBaby();
                return armorModel;
            }
        }, new Item[]{(Item)CreateNjModItems.NETHERITE_JETPACK_CHESTPLATE.get()});
    }

    public NetheriteJetpackItem(ArmorItem.Type type, Item.Properties properties) {
        super(ARMOR_MATERIAL, type, properties);
    }

    public static class Chestplate
    extends NetheriteJetpackItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties().durability(ArmorItem.Type.CHESTPLATE.getDurability(25)).fireResistant());
        }

        @OnlyIn(value=Dist.CLIENT)
        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
            CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            double fuel = 0.0;
            double water = 0.0;
            if (customData != null) {
                CompoundTag tag = customData.copyTag();
                fuel = tag.getDouble("tagFuel");
                water = tag.getDouble("tagWater");
            }
            String tagFuel = String.format("%.1f", fuel);
            String tagWater = String.format("%.1f", water);
            if (Screen.hasShiftDown()) {
                list.add((Component)Component.literal((String)"\u00a78Hold [\u00a7fShift\u00a78] for Summary"));
                list.add((Component)Component.literal((String)"\u00a78Hold [\u00a77Ctrl\u00a78] for Controls"));
                list.add((Component)Component.literal((String)("\u00a77Fuel: \u00a78" + tagFuel + "/6400.0")));
                list.add((Component)Component.literal((String)("\u00a77Water: \u00a78" + tagWater + "/6400.0")));
                list.add((Component)Component.literal((String)" "));
                list.add((Component)Component.literal((String)"\u00a75Take a step back on your constructions"));
                list.add((Component)Component.literal((String)"\u00a75by \u00a7dflying\u00a75 in the sky. It needs \u00a7dwater"));
                list.add((Component)Component.literal((String)"\u00a75and \u00a7dfuel\u00a75 to operate, put it in your"));
                list.add((Component)Component.literal((String)"\u00a75off-hand, then drop your fuel or your"));
                list.add((Component)Component.literal((String)"\u00a75water by pressing Q (coal, wood, water"));
                list.add((Component)Component.literal((String)"\u00a75bucket...)"));
            } else if (Screen.hasControlDown()) {
                list.add((Component)Component.literal((String)"\u00a78Hold [\u00a77Shift\u00a78] for Summary"));
                list.add((Component)Component.literal((String)"\u00a78Hold [\u00a7fCtrl\u00a78] for Controls"));
                list.add((Component)Component.literal((String)("\u00a77Fuel: \u00a78" + tagFuel + "/6400.0")));
                list.add((Component)Component.literal((String)("\u00a77Water: \u00a78" + tagWater + "/6400.0")));
                list.add((Component)Component.literal((String)" "));
                list.add((Component)Component.literal((String)"\u00a77Space in the Air"));
                list.add((Component)Component.literal((String)"\u00a7d Fly\u00a75 with \u00a7dno height limit\u00a75"));
                list.add((Component)Component.literal((String)"\u00a77Space while Sneaking"));
                list.add((Component)Component.literal((String)"\u00a75 Activate \u00a7dhover\u00a75 mode"));
                list.add((Component)Component.literal((String)"\u00a77Space while Swimming"));
                list.add((Component)Component.literal((String)"\u00a75 Activate dive mode and move \u00a7dfaster"));
                list.add((Component)Component.literal((String)"\u00a75 in the \u00a7dwater"));
            } else {
                list.add((Component)Component.literal((String)"\u00a78Hold [\u00a77Shift\u00a78] for Summary"));
                list.add((Component)Component.literal((String)"\u00a78Hold [\u00a77Ctrl\u00a78] for Controls"));
                list.add((Component)Component.literal((String)("\u00a77Fuel: \u00a78" + tagFuel + "/6400.0")));
                list.add((Component)Component.literal((String)("\u00a77Water: \u00a78" + tagWater + "/6400.0")));
            }
            super.appendHoverText(stack, context, list, flag);
        }

        public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
            CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            double tagRotate = 0.0;
            if (data != null) {
                tagRotate = data.copyTag().getDouble("tagRotate");
            }
            switch ((int)tagRotate) {
                case 1: {
                    return ResourceLocation.parse((String)"create_nj:textures/entities/brass_jetpack_2.png");
                }
                case 2: {
                    return ResourceLocation.parse((String)"create_nj:textures/entities/brass_jetpack_3.png");
                }
                case 3: {
                    return ResourceLocation.parse((String)"create_nj:textures/entities/brass_jetpack_4.png");
                }
                case 4: {
                    return ResourceLocation.parse((String)"create_nj:textures/entities/brass_jetpack_5.png");
                }
                case 5: {
                    return ResourceLocation.parse((String)"create_nj:textures/entities/brass_jetpack_6.png");
                }
                case 6: {
                    return ResourceLocation.parse((String)"create_nj:textures/entities/brass_jetpack_7.png");
                }
                case 7: {
                    return ResourceLocation.parse((String)"create_nj:textures/entities/brass_jetpack_8.png");
                }
            }
            return ResourceLocation.parse((String)"create_nj:textures/entities/brass_jetpack_1.png");
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                JetpackTickEventProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), entity, itemstack);
            }
        }
    }
}

