/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.entity_filter;

import com.jesz.createdieselgenerators.content.entity_filter.EntityFilterItem;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class EntityFilteringBehaviour
extends FilteringBehaviour {
    public static final BehaviourType<FilteringBehaviour> TYPE = new BehaviourType();

    public EntityFilteringBehaviour(SmartBlockEntity be, ValueBoxTransform slot) {
        super(be, slot);
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void onShortInteract(Player player, InteractionHand hand, Direction side, BlockHitResult hitResult) {
        Level level = this.getWorld();
        BlockPos pos = this.getPos();
        ItemStack itemInHand = player.getItemInHand(hand);
        ItemStack toApply = itemInHand.copy();
        if (AllItems.WRENCH.isIn(toApply)) {
            return;
        }
        if (AllBlocks.MECHANICAL_ARM.isIn(toApply)) {
            return;
        }
        if (level.isClientSide()) {
            return;
        }
        if (this.getFilter(side).getItem() instanceof EntityFilterItem && (!player.isCreative() || ItemHelper.extract((IItemHandler)new InvWrapper((Container)player.getInventory()), stack -> ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.getFilter(side)), (boolean)true).isEmpty())) {
            player.getInventory().placeItemBackInInventory(this.getFilter(side));
        }
        if (toApply.getItem() instanceof EntityFilterItem) {
            toApply.setCount(1);
        }
        if (!this.setFilter(side, toApply)) {
            player.displayClientMessage((Component)CreateLang.translateDirect((String)"logistics.filter.invalid_item", (Object[])new Object[0]), true);
            AllSoundEvents.DENY.playOnServer(player.level(), (Vec3i)player.blockPosition(), 1.0f, 1.0f);
            return;
        }
        if (!player.isCreative() && toApply.getItem() instanceof EntityFilterItem) {
            if (itemInHand.getCount() == 1) {
                player.setItemInHand(hand, ItemStack.EMPTY);
            } else {
                itemInHand.shrink(1);
            }
        }
        level.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 0.25f, 0.1f);
    }

    public boolean setFilter(ItemStack stack) {
        if (stack.getItem() instanceof FilterItem) {
            return false;
        }
        if (stack.getItem() instanceof EntityFilterItem || stack.isEmpty()) {
            return super.setFilter(stack);
        }
        return false;
    }

    public void destroy() {
        if (this.getFilter().getItem() instanceof EntityFilterItem) {
            Vec3 pos = VecHelper.getCenterOf((Vec3i)this.getPos());
            Level level = this.getWorld();
            level.addFreshEntity((Entity)new ItemEntity(level, pos.x, pos.y, pos.z, this.getFilter().copy()));
        }
        super.destroy();
    }
}

