/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.molds;

import com.google.common.base.Joiner;
import com.jesz.createdieselgenerators.CDGRecipes;
import com.jesz.createdieselgenerators.content.molds.MoldItem;
import com.jesz.createdieselgenerators.content.molds.MoldRecipeParams;
import com.jesz.createdieselgenerators.content.molds.MoldType;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;

public class CastingRecipe
extends StandardProcessingRecipe<RecipeInput> {
    public MoldType moldType;
    MoldRecipeParams params;

    public CastingRecipe(MoldRecipeParams params) {
        super((IRecipeTypeInfo)CDGRecipes.CASTING, (ProcessingRecipeParams)params);
        this.moldType = MoldType.findById(params.mold());
        this.params = params;
    }

    protected int getMaxInputCount() {
        return 0;
    }

    protected int getMaxFluidInputCount() {
        return 1;
    }

    protected int getMaxFluidOutputCount() {
        return 0;
    }

    protected int getMaxOutputCount() {
        return 1;
    }

    public MoldRecipeParams getParams() {
        return this.params;
    }

    public boolean matches(BasinBlockEntity basin, FluidStack fluidStack) {
        if (this.moldType == null) {
            return false;
        }
        if (this.getFluidIngredients().size() != 1) {
            return false;
        }
        IItemHandler availableItems = (IItemHandler)basin.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, basin.getBlockPos(), null);
        if (availableItems == null) {
            return false;
        }
        MoldType moldInBasin = null;
        for (int i = 0; i < availableItems.getSlots(); ++i) {
            ItemStack stack = availableItems.getStackInSlot(i);
            if (!(stack.getItem() instanceof MoldItem) || MoldItem.getMold(stack) != this.moldType) continue;
            moldInBasin = MoldItem.getMold(stack);
        }
        if (moldInBasin == null) {
            return false;
        }
        return ((FluidIngredient)this.getFluidIngredients().get(0)).test(fluidStack);
    }

    public int execute(BasinBlockEntity basin, boolean simulate) {
        IItemHandler availableItems = (IItemHandler)basin.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, basin.getBlockPos(), null);
        if (availableItems == null) {
            return 0;
        }
        MoldType moldInBasin = null;
        for (int i = 0; i < availableItems.getSlots(); ++i) {
            ItemStack stack = availableItems.getStackInSlot(i);
            if (!(stack.getItem() instanceof MoldItem) || MoldItem.getMold(stack) != this.moldType) continue;
            moldInBasin = MoldItem.getMold(stack);
        }
        if (moldInBasin == null) {
            return 0;
        }
        ArrayList recipeOutputItems = new ArrayList();
        if (!simulate) {
            recipeOutputItems.addAll(this.rollResults());
        }
        if (!basin.acceptOutputs(recipeOutputItems, List.of(), false)) {
            return 0;
        }
        return ((FluidIngredient)this.getFluidIngredients().get(0)).getRequiredAmount();
    }

    public boolean matches(RecipeInput input, Level level) {
        return false;
    }

    public static class Serializer
    implements RecipeSerializer<CastingRecipe> {
        private final MapCodec<CastingRecipe> codec = MoldRecipeParams.CODEC.xmap(CastingRecipe::new, CastingRecipe::getParams).validate(recipe -> {
            List errors = recipe.validate();
            if (errors.isEmpty()) {
                return DataResult.success((Object)recipe);
            }
            errors.add(((Object)recipe).getClass().getSimpleName() + " failed validation:");
            return DataResult.error(() -> Joiner.on((char)'\n').join((Iterable)errors), (Object)recipe);
        });
        private final StreamCodec<RegistryFriendlyByteBuf, CastingRecipe> streamCodec = MoldRecipeParams.STREAM_CODEC.map(CastingRecipe::new, CastingRecipe::getParams);

        public MapCodec<CastingRecipe> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CastingRecipe> streamCodec() {
            return this.streamCodec;
        }
    }
}

