/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.oil_barrel;

import com.jesz.createdieselgenerators.CDGMountedStorageTypes;
import com.jesz.createdieselgenerators.content.oil_barrel.OilBarrelBlockEntity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.api.contraption.storage.SyncedMountedStorage;
import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorageType;
import com.simibubi.create.api.contraption.storage.fluid.WrapperMountedFluidStorage;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.Nullable;

public class OilBarrelMountedStorage
extends WrapperMountedFluidStorage<Handler>
implements SyncedMountedStorage {
    public static final MapCodec<OilBarrelMountedStorage> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("capacity").forGetter(OilBarrelMountedStorage::getCapacity), (App)FluidStack.OPTIONAL_CODEC.fieldOf("fluid").forGetter(OilBarrelMountedStorage::getFluid)).apply((Applicative)i, OilBarrelMountedStorage::new));
    private boolean dirty;

    protected OilBarrelMountedStorage(MountedFluidStorageType<?> type, int capacity, FluidStack stack) {
        super(type, (IFluidHandler)new Handler(capacity, stack));
        ((Handler)this.wrapped).onChange = () -> {
            this.dirty = true;
        };
    }

    public OilBarrelMountedStorage(int capacity, FluidStack stack) {
        this((MountedFluidStorageType)CDGMountedStorageTypes.OIL_BARREL.get(), capacity, stack);
    }

    public void unmount(Level level, BlockState state, BlockPos pos, @Nullable BlockEntity be) {
        FluidTank inventory;
        OilBarrelBlockEntity tank;
        if (be instanceof OilBarrelBlockEntity && (tank = (OilBarrelBlockEntity)be).isController() && (inventory = tank.tankInventory) != null) {
            inventory.setFluid(((Handler)this.wrapped).getFluid());
        }
    }

    public FluidStack getFluid() {
        return ((Handler)this.wrapped).getFluid();
    }

    public int getCapacity() {
        return ((Handler)this.wrapped).getCapacity();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markClean() {
        this.dirty = false;
    }

    public void afterSync(Contraption contraption, BlockPos localPos) {
        BlockEntity be = (BlockEntity)contraption.presentBlockEntities.get(localPos);
        if (!(be instanceof FluidTankBlockEntity)) {
            return;
        }
        FluidTankBlockEntity tank = (FluidTankBlockEntity)be;
        FluidTank inv = tank.getTankInventory();
        inv.setFluid(this.getFluid());
        float fillLevel = (float)inv.getFluidAmount() / (float)inv.getCapacity();
        if (tank.getFluidLevel() == null) {
            tank.setFluidLevel(LerpedFloat.linear().startWithValue((double)fillLevel));
        }
        tank.getFluidLevel().chase((double)fillLevel, 0.5, LerpedFloat.Chaser.EXP);
    }

    public static OilBarrelMountedStorage fromTank(OilBarrelBlockEntity tank) {
        FluidTank inventory = tank.tankInventory;
        return new OilBarrelMountedStorage(inventory.getCapacity(), inventory.getFluid().copy());
    }

    public static final class Handler
    extends FluidTank {
        private Runnable onChange = () -> {};

        public Handler(int capacity, FluidStack stack) {
            super(capacity);
            this.setFluid(stack);
        }

        protected void onContentsChanged() {
            this.onChange.run();
        }
    }
}

