/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.tools.hammer;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.jesz.createdieselgenerators.CDGDataComponents;
import com.jesz.createdieselgenerators.CDGRecipes;
import com.jesz.createdieselgenerators.content.tools.hammer.HammerItemRenderer;
import com.jesz.createdieselgenerators.content.tools.hammer.HammerRecipe;
import com.simibubi.create.content.equipment.sandPaper.SandPaperItemComponent;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import java.util.Optional;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;

public class HammerItem
extends Item {
    Multimap<Attribute, AttributeModifier> toolAttributes;

    public HammerItem(Item.Properties properties) {
        super(properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)((Attribute)Attributes.ATTACK_DAMAGE.value()), (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 6.0, AttributeModifier.Operation.ADD_VALUE));
        builder.put((Object)((Attribute)Attributes.ATTACK_SPEED.value()), (Object)new AttributeModifier(BASE_ATTACK_SPEED_ID, -3.1, AttributeModifier.Operation.ADD_VALUE));
        this.toolAttributes = builder.build();
    }

    public InteractionResult useOn(UseOnContext context) {
        return this.use(context.getLevel(), context.getPlayer(), context.getHand()).getResult();
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 9.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -1.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        InteractionHand otherHand = InteractionHand.values()[~hand.ordinal() & 1];
        ItemStack itemInHand = player.getItemInHand(hand);
        ItemStack itemInOtherHand = player.getItemInHand(otherHand);
        HammerRecipe.HammerInv hammerInv = new HammerRecipe.HammerInv(itemInOtherHand);
        Optional recipe = level.getRecipeManager().getRecipeFor(CDGRecipes.HAMMERING.getType(), (RecipeInput)hammerInv, level);
        if (recipe.isPresent()) {
            ItemStack processingItem = itemInOtherHand.copy();
            itemInOtherHand.shrink(1);
            processingItem.setCount(1);
            itemInHand.set(CDGDataComponents.PROCESSING_ITEM, (Object)new SandPaperItemComponent(processingItem));
            player.startUsingItem(hand);
            return InteractionResultHolder.success((Object)itemInHand);
        }
        return super.use(level, player, hand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return stack;
        }
        Player player = (Player)entity;
        String string = "hammer_release";
        synchronized ("hammer_release") {
            if (!stack.has(CDGDataComponents.PROCESSING_ITEM)) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return stack;
            }
            ItemStack processingItem = ((SandPaperItemComponent)stack.get(CDGDataComponents.PROCESSING_ITEM)).item();
            HammerRecipe.HammerInv hammerInv = new HammerRecipe.HammerInv(processingItem);
            Optional recipe = level.getRecipeManager().getRecipeFor(CDGRecipes.HAMMERING.getType(), (RecipeInput)hammerInv, level);
            stack.remove(CDGDataComponents.PROCESSING_ITEM);
            if (recipe.isEmpty()) {
                player.getInventory().placeItemBackInInventory(processingItem);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return stack;
            }
            ((HammerRecipe)((RecipeHolder)recipe.get()).value()).rollResults();
            player.getInventory().placeItemBackInInventory(((HammerRecipe)((RecipeHolder)recipe.get()).value()).assemble((RecipeInput)hammerInv, (HolderLookup.Provider)level.registryAccess()).copy());
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                stack.hurtAndBreak(1, sl, (LivingEntity)player, i -> {});
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return stack;
        }
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int tick) {
        if (AnimationTickHolder.getTicks() % 10 == 0) {
            level.playLocalSound(entity.xo, entity.yo, entity.zo, SoundEvents.ANVIL_PLACE, SoundSource.PLAYERS, 0.3f, 1.0f, true);
            if (!stack.has(CDGDataComponents.PROCESSING_ITEM)) {
                super.onUseTick(level, entity, stack, tick);
                return;
            }
            ItemStack processingItem = ((SandPaperItemComponent)stack.get(CDGDataComponents.PROCESSING_ITEM)).item();
            for (int i = 0; i < 30; ++i) {
                Vec3 offset = VecHelper.offsetRandomly((Vec3)entity.position().add(Math.sin((double)(-entity.getYRot() / 180.0f) * Math.PI) / 2.0, 1.3, Math.cos((double)(-entity.getYRot() / 180.0f) * Math.PI) / 2.0), (RandomSource)level.getRandom(), (float)0.3f);
                Vec3 motion = VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)level.getRandom(), (float)0.1f);
                level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, processingItem), offset.x(), offset.y(), offset.z(), motion.x(), motion.y(), motion.z());
            }
        }
        super.onUseTick(level, entity, stack, tick);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int tick) {
        String string = "hammer_release";
        synchronized ("hammer_release") {
            if (!(entity instanceof Player)) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
            Player player = (Player)entity;
            if (!stack.has(CDGDataComponents.PROCESSING_ITEM)) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
            ItemStack processingItem = ((SandPaperItemComponent)stack.get(CDGDataComponents.PROCESSING_ITEM)).item();
            player.getInventory().placeItemBackInInventory(processingItem);
            stack.remove(CDGDataComponents.PROCESSING_ITEM);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        this.releaseUsing(stack, entity.level(), entity, 0);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 90;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerExtension(RegisterClientExtensionsEvent event) {
        event.registerItem((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new HammerItemRenderer()), new Item[]{this});
    }
}

