/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.tools.wire_cutters;

import com.jesz.createdieselgenerators.CDGDataComponents;
import com.jesz.createdieselgenerators.CDGRecipes;
import com.jesz.createdieselgenerators.content.tools.wire_cutters.WireCuttersItemRenderer;
import com.jesz.createdieselgenerators.content.tools.wire_cutters.WireCuttingRecipe;
import com.simibubi.create.content.equipment.sandPaper.SandPaperItemComponent;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import java.util.Optional;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;

public class WireCuttersItem
extends Item {
    public WireCuttersItem(Item.Properties properties) {
        super(properties.stacksTo(1).durability(32));
    }

    public InteractionResult useOn(UseOnContext context) {
        return this.use(context.getLevel(), context.getPlayer(), context.getHand()).getResult();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        InteractionHand otherHand = InteractionHand.values()[~hand.ordinal() & 1];
        ItemStack itemInHand = player.getItemInHand(hand);
        ItemStack itemInOtherHand = player.getItemInHand(otherHand);
        WireCuttingRecipe.WireCuttingInv inv = new WireCuttingRecipe.WireCuttingInv(itemInOtherHand);
        Optional recipe = level.getRecipeManager().getRecipeFor(CDGRecipes.WIRE_CUTTING.getType(), (RecipeInput)inv, level);
        if (recipe.isPresent()) {
            ItemStack processingItem = itemInOtherHand.copy();
            itemInOtherHand.shrink(1);
            processingItem.setCount(1);
            itemInHand.set(CDGDataComponents.PROCESSING_ITEM, (Object)new SandPaperItemComponent(processingItem));
            player.startUsingItem(hand);
            return InteractionResultHolder.success((Object)itemInHand);
        }
        return super.use(level, player, hand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return stack;
        }
        Player player = (Player)entity;
        String string = "wire_cutters_release";
        synchronized ("wire_cutters_release") {
            if (!stack.has(CDGDataComponents.PROCESSING_ITEM)) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return stack;
            }
            ItemStack processingItem = ((SandPaperItemComponent)stack.get(CDGDataComponents.PROCESSING_ITEM)).item();
            WireCuttingRecipe.WireCuttingInv inv = new WireCuttingRecipe.WireCuttingInv(processingItem);
            Optional recipe = level.getRecipeManager().getRecipeFor(CDGRecipes.WIRE_CUTTING.getType(), (RecipeInput)inv, level);
            stack.remove(CDGDataComponents.PROCESSING_ITEM);
            if (recipe.isEmpty()) {
                player.getInventory().placeItemBackInInventory(processingItem);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return stack;
            }
            ((WireCuttingRecipe)((RecipeHolder)recipe.get()).value()).rollResults();
            player.getInventory().placeItemBackInInventory(((WireCuttingRecipe)((RecipeHolder)recipe.get()).value()).assemble((RecipeInput)inv, (HolderLookup.Provider)level.registryAccess()).copy());
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                stack.hurtAndBreak(1, sl, (LivingEntity)player, i -> {});
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return stack;
        }
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int tick) {
        if (AnimationTickHolder.getTicks() % 10 == 0) {
            level.playLocalSound(entity.xo, entity.yo, entity.zo, SoundEvents.SHEEP_SHEAR, SoundSource.PLAYERS, 0.3f, 1.0f, true);
            if (!stack.has(CDGDataComponents.PROCESSING_ITEM)) {
                super.onUseTick(level, entity, stack, tick);
                return;
            }
            ItemStack processingItem = ((SandPaperItemComponent)stack.get(CDGDataComponents.PROCESSING_ITEM)).item();
            for (int i = 0; i < 30; ++i) {
                Vec3 offset = VecHelper.offsetRandomly((Vec3)entity.position().add(Math.sin((double)(-entity.getYRot() / 180.0f) * Math.PI) / 2.0, 1.3, Math.cos((double)(-entity.getYRot() / 180.0f) * Math.PI) / 2.0), (RandomSource)level.getRandom(), (float)0.3f);
                Vec3 motion = VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)level.getRandom(), (float)0.1f);
                level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, processingItem), offset.x(), offset.y(), offset.z(), motion.x(), motion.y(), motion.z());
            }
        }
        super.onUseTick(level, entity, stack, tick);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int tick) {
        String string = "wire_cutters_release";
        synchronized ("wire_cutters_release") {
            if (!(entity instanceof Player)) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
            Player player = (Player)entity;
            if (!stack.has(CDGDataComponents.PROCESSING_ITEM)) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
            ItemStack processingItem = ((SandPaperItemComponent)stack.get(CDGDataComponents.PROCESSING_ITEM)).item();
            player.getInventory().placeItemBackInInventory(processingItem);
            stack.remove(CDGDataComponents.PROCESSING_ITEM);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        this.releaseUsing(stack, entity.level(), entity, 0);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 90;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerExtension(RegisterClientExtensionsEvent event) {
        event.registerItem((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new WireCuttersItemRenderer()), new Item[]{this});
    }
}

