/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry;

import com.simibubi.create.foundation.data.CreateBlockEntityBuilder;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.BlockEntityBuilder;
import com.tterrag.registrate.builders.Builder;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CFIRegistrate
extends AbstractRegistrate<CFIRegistrate> {
    protected final Logger logger;
    protected final Map<Holder<?>, Holder<CreativeModeTab>> creativeModeTabLookup = new HashMap();
    @Nullable
    protected Holder<CreativeModeTab> creativeModeTab;
    @Nullable
    protected Function<Item, TooltipModifier> tooltipModifier;

    protected CFIRegistrate(String modId) {
        super(modId);
        this.defaultCreativeTab(null);
        this.logger = LoggerFactory.getLogger((String)(((Object)((Object)this)).getClass().getSimpleName() + "[" + modId + "]"));
    }

    public static CFIRegistrate create(String modId) {
        return new CFIRegistrate(modId);
    }

    public CFIRegistrate setCreativeModeTab(@Nullable Holder<CreativeModeTab> creativeModeTab) {
        this.creativeModeTab = creativeModeTab;
        return this;
    }

    public CFIRegistrate setTooltipModifier(@Nullable Function<Item, TooltipModifier> tooltipModifier) {
        this.tooltipModifier = tooltipModifier;
        return this;
    }

    protected <R, T extends R> RegistryEntry<R, T> accept(String name, ResourceKey<? extends Registry<R>> type, Builder<R, T, ?, ?> builder, NonNullSupplier<? extends T> creator, NonNullFunction<DeferredHolder<R, T>, ? extends RegistryEntry<R, T>> entryFactory) {
        RegistryEntry entry = super.accept(name, type, builder, creator, entryFactory);
        if (type.equals((Object)Registries.ITEM) && this.tooltipModifier != null) {
            Function<Item, TooltipModifier> modifier = this.tooltipModifier;
            this.addRegisterCallback(name, Registries.ITEM, item -> {
                TooltipModifier modifierInstance = (TooltipModifier)modifier.apply((Item)item);
                TooltipModifier.REGISTRY.register(item, (Object)modifierInstance);
            });
        }
        if (this.creativeModeTab != null) {
            this.creativeModeTabLookup.put((Holder<?>)entry, this.creativeModeTab);
        }
        return entry;
    }

    public <T extends BlockEntity> CreateBlockEntityBuilder<T, CFIRegistrate> blockEntity(String name, BlockEntityBuilder.BlockEntityFactory<T> factory) {
        return this.blockEntity((CFIRegistrate)this.self(), name, factory);
    }

    public <T extends BlockEntity, P> CreateBlockEntityBuilder<T, P> blockEntity(P parent, String name, BlockEntityBuilder.BlockEntityFactory<T> factory) {
        return (CreateBlockEntityBuilder)this.entry(name, callback -> CreateBlockEntityBuilder.create((AbstractRegistrate)this, (Object)parent, (String)name, (BuilderCallback)callback, (BlockEntityBuilder.BlockEntityFactory)factory));
    }

    public ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)this.getModid(), (String)path);
    }
}

