/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.block.FrameTrap;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.equipment.wrench.WrenchItem;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.block.WrenchableDirectionalBlock;
import java.util.List;
import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;

public class FrameTrapBlock
extends WrenchableDirectionalBlock
implements ProperWaterloggedBlock,
IWrenchable {
    protected static final int PLACEMENT_HELPER_ID = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public FrameTrapBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.SOUTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.getItem() instanceof WrenchItem) {
            InteractionResult result;
            UseOnContext wrenchContext = new UseOnContext(level, player, hand, stack, hitResult);
            InteractionResult interactionResult = result = player.isShiftKeyDown() ? this.onSneakWrenched(state, wrenchContext) : this.onWrenched(state, wrenchContext);
            if (result != InteractionResult.PASS) {
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        IPlacementHelper placementHelper = PlacementHelpers.get((int)PLACEMENT_HELPER_ID);
        if (!player.isShiftKeyDown() && player.mayBuild() && placementHelper.matchesItem(stack)) {
            placementHelper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)stack.getItem(), player, hand, hitResult);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        VoxelShape frame = Shapes.box((double)0.0, (double)0.4375, (double)0.0, (double)1.0, (double)0.5625, (double)1.0);
        VoxelShape net = Shapes.box((double)0.125, (double)0.4375, (double)0.125, (double)0.875, (double)0.4375, (double)0.875);
        VoxelShape baseShape = Shapes.or((VoxelShape)frame, (VoxelShape)net);
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> baseShape;
            case Direction.DOWN -> this.preciseRotateX(baseShape, 180);
            case Direction.NORTH -> this.preciseRotateX(baseShape, 90);
            case Direction.SOUTH -> this.preciseRotateX(baseShape, -90);
            case Direction.WEST -> this.preciseRotateZ(baseShape, 90);
            case Direction.EAST -> this.preciseRotateZ(baseShape, -90);
        };
    }

    private VoxelShape preciseRotateX(VoxelShape shape, int degrees) {
        List boxes = shape.toAabbs();
        VoxelShape[] result = new VoxelShape[]{Shapes.empty()};
        double cos = Mth.cos((float)((float)Math.toRadians(degrees)));
        double sin = Mth.sin((float)((float)Math.toRadians(degrees)));
        boxes.forEach(box -> {
            AABB rotated = new AABB(this.preciseRound(box.minX), this.preciseRound(cos * (box.minY - 0.5) - sin * (box.minZ - 0.5) + 0.5), this.preciseRound(sin * (box.minY - 0.5) + cos * (box.minZ - 0.5) + 0.5), this.preciseRound(box.maxX), this.preciseRound(cos * (box.maxY - 0.5) - sin * (box.maxZ - 0.5) + 0.5), this.preciseRound(sin * (box.maxY - 0.5) + cos * (box.maxZ - 0.5) + 0.5));
            result[0] = Shapes.join((VoxelShape)result[0], (VoxelShape)Shapes.create((AABB)rotated), (BooleanOp)BooleanOp.OR);
        });
        return result[0];
    }

    private VoxelShape preciseRotateZ(VoxelShape shape, int degrees) {
        List boxes = shape.toAabbs();
        VoxelShape[] result = new VoxelShape[]{Shapes.empty()};
        double cos = Mth.cos((float)((float)Math.toRadians(degrees)));
        double sin = Mth.sin((float)((float)Math.toRadians(degrees)));
        boxes.forEach(box -> {
            AABB rotated = new AABB(this.preciseRound(cos * (box.minX - 0.5) - sin * (box.minY - 0.5) + 0.5), this.preciseRound(sin * (box.minX - 0.5) + cos * (box.minY - 0.5) + 0.5), this.preciseRound(box.minZ), this.preciseRound(cos * (box.maxX - 0.5) - sin * (box.maxY - 0.5) + 0.5), this.preciseRound(sin * (box.maxX - 0.5) + cos * (box.maxY - 0.5) + 0.5), this.preciseRound(box.maxZ));
            result[0] = Shapes.join((VoxelShape)result[0], (VoxelShape)Shapes.create((AABB)rotated), (BooleanOp)BooleanOp.OR);
        });
        return result[0];
    }

    private double preciseRound(double value) {
        return (double)Math.round(value * 16.0) / 16.0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{WATERLOGGED}));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            state = this.defaultBlockState();
        }
        state = (BlockState)state.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)).getOpposite());
        return this.withWater(state, context);
    }

    public FluidState getFluidState(BlockState state) {
        return this.fluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        this.updateWater(level, state, pos);
        return state;
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (entity.isSuppressingBounce()) {
            super.fallOn(level, state, pos, entity, fallDistance);
        } else {
            entity.causeFallDamage(fallDistance, 0.0f, level.damageSources().fall());
        }
    }

    public void updateEntityAfterFallOn(BlockGetter level, Entity entityIn) {
        if (entityIn.isSuppressingBounce()) {
            super.updateEntityAfterFallOn(level, entityIn);
        } else {
            this.bounceEntity(entityIn);
        }
    }

    protected void bounceEntity(Entity entity) {
        Vec3 vec3d = entity.getDeltaMovement();
        if (vec3d.y < 0.0) {
            double entityWeightOffset = entity instanceof LivingEntity ? 0.6 : 0.8;
            entity.setDeltaMovement(vec3d.x, -vec3d.y * entityWeightOffset, vec3d.z);
        }
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState rotated = this.getRotatedBlockState(state, context.getClickedFace());
        if (!rotated.canSurvive((LevelReader)level, pos)) {
            return InteractionResult.PASS;
        }
        if (level.setBlock(pos, rotated, 3)) {
            IWrenchable.playRotateSound((Level)level, (BlockPos)pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(level, pos, state, player);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return InteractionResult.SUCCESS;
        }
        if (player != null && !player.isCreative()) {
            Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, null, (Entity)player, (ItemStack)context.getItemInHand()).forEach(itemStack -> player.getInventory().placeItemBackInInventory(itemStack));
        }
        state.spawnAfterBreak(serverLevel, pos, ItemStack.EMPTY, true);
        level.destroyBlock(pos, false);
        IWrenchable.playRemoveSound((Level)level, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    public BlockState updateAfterWrenched(BlockState newState, UseOnContext context) {
        return Block.updateFromNeighbourShapes((BlockState)newState, (LevelAccessor)context.getLevel(), (BlockPos)context.getClickedPos());
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        if (!originalState.hasProperty((Property)FACING)) {
            return originalState;
        }
        Direction currentFacing = (Direction)originalState.getValue((Property)FACING);
        if (currentFacing.getAxis().equals((Object)targetedFace.getAxis())) {
            return originalState;
        }
        Direction newFacing = currentFacing.getClockWise(targetedFace.getAxis());
        return (BlockState)originalState.setValue((Property)FACING, (Comparable)newFacing);
    }

    protected static class PlacementHelper
    implements IPlacementHelper {
        protected PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return stack -> {
                BlockItem blockItem;
                Item patt0$temp = stack.getItem();
                return patt0$temp instanceof BlockItem && (blockItem = (BlockItem)patt0$temp).getBlock() instanceof FrameTrapBlock;
            };
        }

        public Predicate<BlockState> getStatePredicate() {
            return state -> state.getBlock() instanceof FrameTrapBlock;
        }

        public PlacementOffset getOffset(Player player, Level level, BlockState state, BlockPos pos, BlockHitResult hit) {
            List directions = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)hit.getLocation(), (Direction.Axis)((Direction)state.getValue((Property)FACING)).getAxis(), direction -> level.getBlockState(pos.relative(direction)).canBeReplaced());
            if (directions.isEmpty()) {
                return PlacementOffset.fail();
            }
            return PlacementOffset.success((Vec3i)pos.relative((Direction)directions.getFirst()), placed -> (BlockState)placed.setValue((Property)DirectionalBlock.FACING, (Comparable)((Direction)state.getValue((Property)DirectionalBlock.FACING))));
        }
    }
}

