/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.block.common;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TrapBlockEntity
extends BlockEntity {
    public static final int INVENTORY_SLOTS = 9;
    protected static final double COLLECTION_RANGE = 1.5;
    protected static final double FISH_PROCESSING_RANGE = 1.5;
    protected final ItemStackHandler inventory = this.createInventory();
    protected int processingTicks = 0;
    protected int syncCooldown = 0;
    protected boolean queuedSync = false;
    private static final int SYNC_RATE = 8;
    private final Lazy<IItemHandler> itemHandlerLazy = Lazy.of(() -> this.inventory);

    public TrapBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected ItemStackHandler createInventory() {
        return new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                TrapBlockEntity.this.setChanged();
                if (TrapBlockEntity.this.level != null && !TrapBlockEntity.this.level.isClientSide()) {
                    TrapBlockEntity.this.level.sendBlockUpdated(TrapBlockEntity.this.worldPosition, TrapBlockEntity.this.getBlockState(), TrapBlockEntity.this.getBlockState(), 3);
                    TrapBlockEntity.this.sendData();
                }
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return true;
            }

            public CompoundTag serializeNBT(HolderLookup.Provider provider) {
                CompoundTag nbt = super.serializeNBT(provider);
                return nbt;
            }

            public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
                super.deserializeNBT(provider, nbt);
            }
        };
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public boolean insertItem(ItemStack stack) {
        boolean partialSuccess;
        if (stack.isEmpty() || this.level == null || this.level.isClientSide()) {
            return false;
        }
        ItemStack remainder = stack.copy();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (!(remainder = this.inventory.insertItem(i, remainder, false)).isEmpty()) continue;
            this.setChanged();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.sendData();
            return true;
        }
        boolean bl = partialSuccess = stack.getCount() != remainder.getCount();
        if (partialSuccess) {
            this.setChanged();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.sendData();
        }
        return partialSuccess;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        CompoundTag inventoryTag = this.inventory.serializeNBT(provider);
        tag.put("Inventory", (Tag)inventoryTag);
        tag.putInt("ProcessingTicks", this.processingTicks);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("Inventory")) {
            CompoundTag inventoryTag = tag.getCompound("Inventory");
            this.inventory.deserializeNBT(provider, inventoryTag);
        }
        this.processingTicks = tag.getInt("ProcessingTicks");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.saveAdditional(tag, provider);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        super.onDataPacket(net, pkt, provider);
        this.handleUpdateTag(pkt.getTag(), provider);
    }

    @Nullable
    public <T> T getCapability(BlockCapability<T, @Nullable Direction> capability, @Nullable Direction side) {
        if (capability == Capabilities.ItemHandler.BLOCK) {
            return (T)this.inventory;
        }
        return null;
    }

    protected void collectNearbyItems(ServerLevel level) {
        if (level == null || level.isClientSide()) {
            return;
        }
        AABB boundingBox = new AABB(this.getBlockPos()).inflate(1.5);
        List items = level.getEntitiesOfClass(ItemEntity.class, boundingBox);
        for (ItemEntity itemEntity : items) {
            ItemStack stack;
            if (itemEntity == null || !itemEntity.isAlive() || (stack = itemEntity.getItem()).isEmpty()) continue;
            ItemStack copy = stack.copy();
            if (this.insertItem(copy)) {
                itemEntity.discard();
                continue;
            }
            if (copy.getCount() >= stack.getCount()) continue;
            itemEntity.setItem(copy);
        }
    }

    protected void tryProcessFish(ServerLevel level) {
        if (level == null || level.isClientSide()) {
            return;
        }
        AABB boundingBox = new AABB(this.getBlockPos()).inflate(1.5);
        List entities = level.getEntitiesOfClass(Entity.class, boundingBox);
        for (Entity entity : entities) {
            Mob mob;
            boolean isAquatic;
            if (entity == null || !entity.isAlive() || !(isAquatic = entity instanceof WaterAnimal || entity.getType() == EntityType.COD || entity.getType() == EntityType.SALMON || entity.getType() == EntityType.TROPICAL_FISH || entity.getType() == EntityType.PUFFERFISH) || !(entity instanceof Mob) || !((mob = (Mob)entity).getMaxHealth() < 10.0f)) continue;
            try {
                mob.hurt(level.damageSources().generic(), mob.getMaxHealth() * 2.0f);
                entity.discard();
            }
            catch (Exception exception) {}
        }
    }

    public void dropInventory() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 pos = Vec3.atCenterOf((Vec3i)this.worldPosition);
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                ItemEntity itemEntity = new ItemEntity(this.level, pos.x, pos.y, pos.z, stack);
                serverLevel.addFreshEntity((Entity)itemEntity);
                this.inventory.setStackInSlot(i, ItemStack.EMPTY);
            }
        }
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.setChanged();
        }
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void tick() {
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
    }
}

