/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.config;

import com.adonis.createfisheryindustry.config.CreateFisheryKineticsConfig;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.createmod.catnip.config.ConfigBase;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.ModConfigSpec;

public class CreateFisheryServerConfig
extends ConfigBase {
    public final CreateFisheryKineticsConfig kinetics = (CreateFisheryKineticsConfig)this.nested(0, CreateFisheryKineticsConfig::new, new String[]{"Parameters and abilities of kinetic mechanisms"});
    public final ModConfigSpec.ConfigValue<List<? extends String>> frameTrapWhitelist;
    public final ModConfigSpec.ConfigValue<List<? extends String>> frameTrapBlacklist;
    private List<ResourceLocation> cachedWhitelist = new ArrayList<ResourceLocation>();
    private List<ResourceLocation> cachedBlacklist = new ArrayList<ResourceLocation>();
    private long lastWhitelistUpdate = 0L;
    private long lastBlacklistUpdate = 0L;

    public CreateFisheryServerConfig(ModConfigSpec.Builder builder) {
        builder.push("frameTrap");
        this.frameTrapWhitelist = builder.comment("List of entity registry names to always allow catching (whitelist). Example: 'minecraft:squid'").defineList("whitelist", (List)ImmutableList.of((Object)"minecraft:phantom", (Object)"minecraft:squid", (Object)"minecraft:spider", (Object)"minecraft:cave_spider", (Object)"minecraft:silverfish"), obj -> obj instanceof String);
        this.frameTrapBlacklist = builder.comment("List of entity registry names to never catch (blacklist). Example: 'minecraft:dolphin'").defineList("blacklist", (List)ImmutableList.of((Object)"minecraft:dolphin", (Object)"minecraft:axolotl", (Object)"minecraft:cat", (Object)"minecraft:allay"), obj -> obj instanceof String);
        builder.pop();
    }

    public String getName() {
        return "server";
    }

    public List<ResourceLocation> getWhitelist() {
        long currentTime = System.currentTimeMillis();
        if (this.cachedWhitelist.isEmpty() || currentTime - this.lastWhitelistUpdate > 5000L) {
            this.cachedWhitelist = ((List)this.frameTrapWhitelist.get()).stream().map(ResourceLocation::tryParse).filter(r -> r != null).collect(Collectors.toList());
            this.lastWhitelistUpdate = currentTime;
        }
        return this.cachedWhitelist;
    }

    public List<ResourceLocation> getBlacklist() {
        long currentTime = System.currentTimeMillis();
        if (this.cachedBlacklist.isEmpty() || currentTime - this.lastBlacklistUpdate > 5000L) {
            this.cachedBlacklist = ((List)this.frameTrapBlacklist.get()).stream().map(ResourceLocation::tryParse).filter(r -> r != null).collect(Collectors.toList());
            this.lastBlacklistUpdate = currentTime;
        }
        return this.cachedBlacklist;
    }

    public void refreshCache() {
        this.lastWhitelistUpdate = 0L;
        this.lastBlacklistUpdate = 0L;
        this.getWhitelist();
        this.getBlacklist();
    }

    public boolean isEntityWhitelisted(ResourceLocation entityId) {
        return this.getWhitelist().contains(entityId);
    }

    public boolean isEntityBlacklisted(ResourceLocation entityId) {
        return this.getBlacklist().contains(entityId);
    }
}

