/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.entity;

import com.adonis.createfisheryindustry.registry.CreateFisheryEntityTypes;
import com.adonis.createfisheryindustry.registry.CreateFisheryItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TetheredHarpoonEntity
extends AbstractArrow {
    private static final Logger LOGGER = LoggerFactory.getLogger(TetheredHarpoonEntity.class);
    private Player owner;
    private BlockPos anchoredPos;
    private boolean anchored = false;
    private boolean retrieving = false;
    private Entity hitEntity = null;
    private int hitTick = 0;
    private int deathDelayTicks = 0;
    private static final int MAX_DEATH_DELAY = 10;
    private Entity lastHitEntity = null;
    private Player lastHitPlayer = null;
    public HarpoonState currentState = HarpoonState.ANCHORED;
    private static final EntityDataAccessor<Boolean> DATA_ANCHORED = SynchedEntityData.defineId(TetheredHarpoonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_RETRIEVING = SynchedEntityData.defineId(TetheredHarpoonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_HOOKED_ENTITY = SynchedEntityData.defineId(TetheredHarpoonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public TetheredHarpoonEntity(EntityType<? extends TetheredHarpoonEntity> type, Level level) {
        super(type, level);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
        this.setBoundingBox(this.makeBoundingBox());
    }

    public TetheredHarpoonEntity(Level level, Player owner, Vec3 position) {
        this((EntityType<? extends TetheredHarpoonEntity>)((EntityType)CreateFisheryEntityTypes.TETHERED_HARPOON.get()), level);
        this.owner = owner;
        this.setPos(position);
        this.setOwner((Entity)owner);
        this.setBoundingBox(this.makeBoundingBox());
        this.setDeltaMovement(Vec3.ZERO);
        this.setNoGravity(true);
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = this.getBoundingBox().getSize() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 *= 64.0 * TetheredHarpoonEntity.getViewScale()) * d0;
    }

    public boolean isInvisible() {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ANCHORED, (Object)false);
        builder.define(DATA_RETRIEVING, (Object)false);
        builder.define(DATA_HOOKED_ENTITY, (Object)0);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (DATA_HOOKED_ENTITY.equals(key)) {
            int id = (Integer)this.getEntityData().get(DATA_HOOKED_ENTITY);
            this.hitEntity = id > 0 ? this.level().getEntity(id - 1) : null;
            HarpoonState harpoonState = this.currentState = this.hitEntity != null ? HarpoonState.HOOKED_IN_ENTITY : HarpoonState.ANCHORED;
        }
        if (DATA_ANCHORED.equals(key)) {
            this.anchored = (Boolean)this.getEntityData().get(DATA_ANCHORED);
            this.currentState = this.anchored ? HarpoonState.ANCHORED : HarpoonState.HOOKED_IN_ENTITY;
        }
    }

    public boolean isAnchored() {
        return (Boolean)this.getEntityData().get(DATA_ANCHORED);
    }

    public boolean isRetrieving() {
        return (Boolean)this.getEntityData().get(DATA_RETRIEVING);
    }

    public Vec3 getAnchoredPosition() {
        return this.anchoredPos != null ? new Vec3((double)this.anchoredPos.getX() + 0.5, (double)this.anchoredPos.getY() + 0.5, (double)this.anchoredPos.getZ() + 0.5) : this.position();
    }

    public void setAnchored(BlockPos pos) {
        ItemStack harpoonGun;
        this.anchoredPos = pos;
        this.anchored = true;
        this.getEntityData().set(DATA_ANCHORED, (Object)true);
        this.currentState = HarpoonState.ANCHORED;
        if (!this.level().isClientSide && this.owner != null && (harpoonGun = this.getHarpoonGunFromPlayer(this.owner)) != null) {
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)harpoonGun, tag -> {
                tag.putBoolean("tagHooked", true);
                tag.putDouble("xPostion", (double)pos.getX() + 0.5);
                tag.putDouble("yPostion", (double)pos.getY() + 0.5);
                tag.putDouble("zPostion", (double)pos.getZ() + 0.5);
                tag.remove("tagHookedEntityId");
            });
        }
    }

    public void setHitEntity(Entity entity, int tick) {
        ItemStack harpoonGun;
        this.hitEntity = entity;
        this.hitTick = tick;
        this.deathDelayTicks = 0;
        this.lastHitEntity = entity;
        this.lastHitPlayer = this.owner;
        this.getEntityData().set(DATA_HOOKED_ENTITY, (Object)(entity != null ? entity.getId() + 1 : 0));
        HarpoonState harpoonState = this.currentState = entity != null ? HarpoonState.HOOKED_IN_ENTITY : HarpoonState.ANCHORED;
        if (!this.level().isClientSide && this.owner != null && (harpoonGun = this.getHarpoonGunFromPlayer(this.owner)) != null) {
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)harpoonGun, tag -> {
                tag.putBoolean("tagHooked", true);
                tag.putInt("tagHookedEntityId", entity != null ? entity.getId() : 0);
                tag.remove("xPostion");
                tag.remove("yPostion");
                tag.remove("zPostion");
            });
        }
    }

    private ItemStack getHarpoonGunFromPlayer(Player player) {
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        if (mainHand.getItem() == CreateFisheryItems.PNEUMATIC_HARPOON_GUN.get()) {
            return mainHand;
        }
        if (offHand.getItem() == CreateFisheryItems.PNEUMATIC_HARPOON_GUN.get()) {
            return offHand;
        }
        return null;
    }

    public Entity getHitEntity() {
        return this.hitEntity;
    }

    public int getHitTick() {
        return this.hitTick;
    }

    public Entity getLastHitEntity() {
        return this.lastHitEntity;
    }

    public Player getLastHitPlayer() {
        return this.lastHitPlayer;
    }

    public void startRetrieving() {
        ItemStack harpoonGun;
        this.retrieving = true;
        this.anchored = false;
        this.hitEntity = null;
        this.anchoredPos = null;
        this.getEntityData().set(DATA_ANCHORED, (Object)false);
        this.getEntityData().set(DATA_RETRIEVING, (Object)true);
        this.getEntityData().set(DATA_HOOKED_ENTITY, (Object)0);
        this.currentState = HarpoonState.FLYING;
        if (!this.level().isClientSide && this.owner != null && (harpoonGun = this.getHarpoonGunFromPlayer(this.owner)) != null) {
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)harpoonGun, tag -> {
                tag.putBoolean("tagHooked", false);
                tag.remove("tagHookedEntityId");
                tag.remove("xPostion");
                tag.remove("yPostion");
                tag.remove("zPostion");
                tag.remove("AccumulatedAirConsumption");
            });
        }
        this.discard();
    }

    public void playSound(SoundEvent sound, float volume, float pitch) {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), sound, this.getSoundSource(), volume, pitch);
    }

    protected boolean canHitEntity(Entity entity) {
        return entity != this.owner && entity.isAlive() && super.canHitEntity(entity);
    }

    public void pullLootToPlayer(Entity deadEntity) {
        ServerLevel serverLevel;
        Player player;
        block8: {
            block7: {
                Entity entity = this.getOwner();
                if (!(entity instanceof Player)) break block7;
                player = (Player)entity;
                entity = this.level();
                if (!(entity instanceof ServerLevel)) break block7;
                serverLevel = (ServerLevel)entity;
                if (deadEntity instanceof Mob) break block8;
            }
            return;
        }
        Mob mob = (Mob)deadEntity;
        ResourceKey lootTableKey = mob.getLootTable();
        if (lootTableKey == null) {
            return;
        }
        LootParams.Builder paramsBuilder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.THIS_ENTITY, (Object)mob).withParameter(LootContextParams.ORIGIN, (Object)mob.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)this.damageSources().playerAttack(player)).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)this);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            paramsBuilder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)serverPlayer);
        }
        LootParams params = paramsBuilder.create(LootContextParamSets.ENTITY);
        LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(lootTableKey);
        long tetherEndTime = serverLevel.getGameTime() + 200L;
        for (ItemStack item : lootTable.getRandomItems(params)) {
            ItemEntity drop = new ItemEntity(this.level(), deadEntity.getX(), deadEntity.getY(), deadEntity.getZ(), item);
            CompoundTag tag = drop.getPersistentData();
            tag.putBoolean("HarpoonTethered", true);
            tag.putInt("TetherPlayerId", player.getId());
            tag.putLong("TetherEndTime", tetherEndTime);
            double dx = player.getX() - drop.getX();
            double dy = player.getY() - drop.getY();
            double dz = player.getZ() - drop.getZ();
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            drop.setDeltaMovement(dx * 0.2, dy * 0.2 + Math.sqrt(distance) * 0.1, dz * 0.2);
            drop.setPickUpDelay(10);
            this.level().addFreshEntity((Entity)drop);
        }
        int xp = ((LivingEntity)deadEntity).getExperienceReward(serverLevel, (Entity)this);
        if (xp > 0) {
            ExperienceOrb orb = new ExperienceOrb(this.level(), deadEntity.getX(), deadEntity.getY(), deadEntity.getZ(), xp);
            CompoundTag tag = orb.getPersistentData();
            tag.putBoolean("HarpoonTethered", true);
            tag.putInt("TetherPlayerId", player.getId());
            tag.putLong("TetherEndTime", tetherEndTime);
            double dx = player.getX() - orb.getX();
            double dy = player.getY() - orb.getY();
            double dz = player.getZ() - orb.getZ();
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            orb.setDeltaMovement(dx * 0.2, dy * 0.2 + Math.sqrt(distance) * 0.1, dz * 0.2);
            this.level().addFreshEntity((Entity)orb);
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.retrieving) {
                this.discard();
                return;
            }
            if (this.currentState == HarpoonState.HOOKED_IN_ENTITY) {
                if (this.hitEntity != null && this.hitEntity.isAlive() && this.hitEntity.level().dimension() == this.level().dimension()) {
                    Vec3 targetPos = this.hitEntity.position().add(0.0, (double)this.hitEntity.getBbHeight() * 0.5, 0.0);
                    this.setPos(targetPos);
                    this.setDeltaMovement(Vec3.ZERO);
                    this.deathDelayTicks = 0;
                } else if (this.deathDelayTicks < 10 && this.hitEntity != null) {
                    ++this.deathDelayTicks;
                } else {
                    this.startRetrieving();
                }
                return;
            }
            if (this.currentState == HarpoonState.ANCHORED) {
                if (this.anchoredPos != null && !this.level().isEmptyBlock(this.anchoredPos)) {
                    this.setDeltaMovement(Vec3.ZERO);
                    this.setPos(this.getAnchoredPosition());
                } else {
                    this.startRetrieving();
                }
                return;
            }
            if (this.tickCount > 400) {
                this.startRetrieving();
            }
        }
    }

    public void playerTouch(Player entity) {
        if (this.ownedBy((Entity)entity) || this.getOwner() == null) {
            super.playerTouch(entity);
        }
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.TRIDENT_HIT_GROUND;
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        Level level;
        int hookedId;
        super.readAdditionalSaveData(compound);
        this.anchored = compound.getBoolean("Anchored");
        this.retrieving = compound.getBoolean("Retrieving");
        this.hitTick = compound.getInt("HitTick");
        if (compound.contains("AnchoredX")) {
            this.anchoredPos = new BlockPos(compound.getInt("AnchoredX"), compound.getInt("AnchoredY"), compound.getInt("AnchoredZ"));
        }
        if ((hookedId = compound.getInt("HookedEntity")) > 0 && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.lastHitEntity = this.hitEntity = serverLevel.getEntity(hookedId);
            this.currentState = this.hitEntity != null ? HarpoonState.HOOKED_IN_ENTITY : HarpoonState.ANCHORED;
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        try {
            super.addAdditionalSaveData(compound);
        }
        catch (IllegalStateException e) {
            compound.putByte("pickup", (byte)this.pickup.ordinal());
            compound.putDouble("damage", this.getBaseDamage());
            compound.putBoolean("crit", this.isCritArrow());
        }
        compound.putBoolean("Anchored", this.anchored);
        compound.putBoolean("Retrieving", this.retrieving);
        compound.putInt("HitTick", this.hitTick);
        if (this.anchoredPos != null) {
            compound.putInt("AnchoredX", this.anchoredPos.getX());
            compound.putInt("AnchoredY", this.anchoredPos.getY());
            compound.putInt("AnchoredZ", this.anchoredPos.getZ());
        }
        compound.putInt("HookedEntity", this.hitEntity != null ? this.hitEntity.getId() : 0);
    }

    protected float getWaterInertia() {
        return 0.99f;
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    public static enum HarpoonState {
        FLYING,
        HOOKED_IN_ENTITY,
        ANCHORED;

    }
}

