/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.event;

import com.adonis.createfisheryindustry.entity.HarpoonEntity;
import com.adonis.createfisheryindustry.item.HarpoonPouchContents;
import com.adonis.createfisheryindustry.registry.CreateFisheryComponents;
import com.adonis.createfisheryindustry.registry.CreateFisheryItems;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="createfisheryindustry")
public class HarpoonPouchEventHandler {
    private static final List<ReplenishTask> replenishTasks = new ArrayList<ReplenishTask>();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onItemPickup(ItemEntityPickupEvent.Pre event) {
        Player player = event.getPlayer();
        ItemEntity itemEntity = event.getItemEntity();
        ItemStack stack = itemEntity.getItem();
        if (stack.getItem() != CreateFisheryItems.HARPOON.get() && stack.getItem() != Items.TRIDENT) {
            return;
        }
        Holder.Reference loyalty = player.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.LOYALTY);
        if (EnchantmentHelper.getItemEnchantmentLevel((Holder)loyalty, (ItemStack)stack) > 0 && HarpoonPouchEventHandler.tryInsertHarpoonToPouch(player, stack)) {
            itemEntity.setItem(ItemStack.EMPTY);
            itemEntity.discard();
            event.setCanPickup(TriState.FALSE);
            return;
        }
        event.setCanPickup(TriState.TRUE);
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        Player player = null;
        ItemStack thrownStack = null;
        Entity entity = event.getEntity();
        if (entity instanceof HarpoonEntity) {
            HarpoonEntity harpoon = (HarpoonEntity)entity;
            player = harpoon.getOwner() instanceof Player ? (Player)harpoon.getOwner() : null;
            thrownStack = harpoon.getPickupItemStackOrigin();
        } else {
            entity = event.getEntity();
            if (entity instanceof ThrownTrident) {
                ThrownTrident trident = (ThrownTrident)entity;
                player = trident.getOwner() instanceof Player ? (Player)trident.getOwner() : null;
                thrownStack = new ItemStack((ItemLike)Items.TRIDENT);
            }
        }
        if (player == null || thrownStack == null) {
            return;
        }
        if (player.hasInfiniteMaterials()) {
            return;
        }
        Holder.Reference loyalty = player.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.LOYALTY);
        Holder.Reference riptide = player.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.RIPTIDE);
        if (EnchantmentHelper.getItemEnchantmentLevel((Holder)loyalty, (ItemStack)thrownStack) > 0 || EnchantmentHelper.getItemEnchantmentLevel((Holder)riptide, (ItemStack)thrownStack) > 0) {
            return;
        }
        replenishTasks.add(new ReplenishTask(player.getUUID(), 1));
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        ArrayList<ReplenishTask> tasksToRemove = new ArrayList<ReplenishTask>();
        for (ReplenishTask task : replenishTasks) {
            --task.ticksRemaining;
            if (task.ticksRemaining > 0) continue;
            ServerPlayer player = event.getServer().getPlayerList().getPlayer(task.playerUUID);
            if (player != null && !player.hasInfiniteMaterials()) {
                for (int i = 0; i < 36; ++i) {
                    ItemStack pouch = player.getInventory().getItem(i);
                    if (pouch.getItem() != CreateFisheryItems.HARPOON_POUCH.get() || !CreateFisheryComponents.HARPOON_POUCH_CONTENTS.isBound()) continue;
                    HarpoonPouchContents contents = (HarpoonPouchContents)pouch.getOrDefault((DataComponentType)CreateFisheryComponents.HARPOON_POUCH_CONTENTS.get(), (Object)HarpoonPouchContents.EMPTY);
                    HarpoonPouchContents.Mutable mutable = new HarpoonPouchContents.Mutable(contents);
                    ItemStack replacement = mutable.removeOne();
                    if (replacement != null) {
                        HarpoonPouchEventHandler.playRemoveOneSound((Player)player);
                        ItemStack mainHand = player.getMainHandItem();
                        if (mainHand.isEmpty()) {
                            player.setItemInHand(player.getUsedItemHand(), replacement);
                        } else {
                            player.getInventory().add(replacement);
                        }
                        pouch.set((DataComponentType)CreateFisheryComponents.HARPOON_POUCH_CONTENTS.get(), (Object)mutable.toImmutable());
                        if (!(player instanceof ServerPlayer)) break;
                        ServerPlayer serverPlayer = player;
                        int slotId = HarpoonPouchEventHandler.getContainerSlotId(i);
                        serverPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(serverPlayer.containerMenu.containerId, serverPlayer.containerMenu.incrementStateId(), slotId, pouch));
                        int totalHarpoons = HarpoonPouchEventHandler.countTotalHarpoons((Player)player);
                        serverPlayer.displayClientMessage((Component)Component.translatable((String)"create_fishery.harpoon_pouch.remaining", (Object[])new Object[]{totalHarpoons}), true);
                        break;
                    }
                    player.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.4f);
                    if (!(player instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = player;
                    serverPlayer.displayClientMessage((Component)Component.translatable((String)"create_fishery.harpoon_pouch.empty"), true);
                }
            }
            tasksToRemove.add(task);
        }
        replenishTasks.removeAll(tasksToRemove);
    }

    public static boolean tryInsertHarpoonToPouch(Player player, ItemStack stack) {
        if (stack.getItem() != CreateFisheryItems.HARPOON.get() && stack.getItem() != Items.TRIDENT) {
            return false;
        }
        boolean handled = false;
        for (int i = 0; i < 36; ++i) {
            HarpoonPouchContents contents;
            HarpoonPouchContents.Mutable mutable;
            int inserted;
            ItemStack pouch = player.getInventory().getItem(i);
            if (pouch.getItem() != CreateFisheryItems.HARPOON_POUCH.get() || !CreateFisheryComponents.HARPOON_POUCH_CONTENTS.isBound() || (inserted = (mutable = new HarpoonPouchContents.Mutable(contents = (HarpoonPouchContents)pouch.getOrDefault((DataComponentType)CreateFisheryComponents.HARPOON_POUCH_CONTENTS.get(), (Object)HarpoonPouchContents.EMPTY))).tryInsert(stack)) <= 0) continue;
            HarpoonPouchEventHandler.playInsertSound(player);
            pouch.set((DataComponentType)CreateFisheryComponents.HARPOON_POUCH_CONTENTS.get(), (Object)mutable.toImmutable());
            stack.shrink(inserted);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                int slotId = HarpoonPouchEventHandler.getContainerSlotId(i);
                serverPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(serverPlayer.containerMenu.containerId, serverPlayer.containerMenu.incrementStateId(), slotId, pouch));
                int totalHarpoons = HarpoonPouchEventHandler.countTotalHarpoons(player);
                serverPlayer.displayClientMessage((Component)Component.translatable((String)"create_fishery.harpoon_pouch.remaining", (Object[])new Object[]{totalHarpoons}), true);
            }
            handled = true;
            if (!stack.isEmpty()) continue;
            return true;
        }
        if (!stack.isEmpty() && handled && player.getInventory().add(stack)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                int totalHarpoons = HarpoonPouchEventHandler.countTotalHarpoons(player);
                serverPlayer.displayClientMessage((Component)Component.translatable((String)"create_fishery.harpoon_pouch.remaining", (Object[])new Object[]{totalHarpoons}), true);
            }
            return true;
        }
        return handled;
    }

    private static int getContainerSlotId(int inventoryIndex) {
        if (inventoryIndex < 9) {
            return inventoryIndex + 36;
        }
        return inventoryIndex;
    }

    private static int countTotalHarpoons(Player player) {
        int totalHarpoons = 0;
        for (int i = 0; i < 36; ++i) {
            ItemStack pouch = player.getInventory().getItem(i);
            if (pouch.getItem() != CreateFisheryItems.HARPOON_POUCH.get() || !CreateFisheryComponents.HARPOON_POUCH_CONTENTS.isBound()) continue;
            HarpoonPouchContents contents = (HarpoonPouchContents)pouch.getOrDefault((DataComponentType)CreateFisheryComponents.HARPOON_POUCH_CONTENTS.get(), (Object)HarpoonPouchContents.EMPTY);
            for (ItemStack stack : contents.items()) {
                if (stack.getItem() != CreateFisheryItems.HARPOON.get() && stack.getItem() != Items.TRIDENT) continue;
                totalHarpoons += stack.getCount();
            }
        }
        return totalHarpoons;
    }

    private static void playInsertSound(Player player) {
        player.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.4f);
    }

    private static void playRemoveOneSound(Player player) {
        player.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.4f);
    }

    private static class ReplenishTask {
        UUID playerUUID;
        int ticksRemaining;

        ReplenishTask(UUID playerUUID, int ticksRemaining) {
            this.playerUUID = playerUUID;
            this.ticksRemaining = ticksRemaining;
        }
    }
}

