/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.event;

import com.adonis.createfisheryindustry.config.CreateFisheryCommonConfig;
import com.adonis.createfisheryindustry.registry.CreateFisheryBlocks;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="createfisheryindustry")
public class MeshTrapInteractionHandler {
    private static final double MAX_COLLISION_BOX_SIZE = 0.8;

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Mob mob;
        Level level;
        Player player = event.getEntity();
        ItemStack heldItem = player.getMainHandItem();
        Entity target = event.getTarget();
        if (!heldItem.is(CreateFisheryBlocks.MESH_TRAP.asItem())) {
            return;
        }
        if (player.level().isClientSide() || !((level = player.level()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!(target instanceof Mob) || !(mob = (Mob)target).isAlive()) {
            return;
        }
        if (!MeshTrapInteractionHandler.canCaptureEntity(mob)) {
            return;
        }
        MeshTrapInteractionHandler.processEntityDrops(serverLevel, mob, player);
        mob.setRemoved(Entity.RemovalReason.KILLED);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.swing(InteractionHand.MAIN_HAND, true);
        }
        event.setCanceled(true);
    }

    private static boolean canCaptureEntity(Mob mob) {
        CreateFisheryCommonConfig.refreshCache();
        EntityType entityType = mob.getType();
        ResourceLocation entityId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityType);
        if (CreateFisheryCommonConfig.isEntityBlacklisted(entityId)) {
            return false;
        }
        if (CreateFisheryCommonConfig.isEntityWhitelisted(entityId)) {
            return true;
        }
        AABB collisionBox = mob.getBoundingBox();
        double width = collisionBox.getXsize();
        double height = collisionBox.getYsize();
        double depth = collisionBox.getZsize();
        return width <= 0.8 && height <= 0.8 && depth <= 0.8;
    }

    private static void processEntityDrops(ServerLevel level, Mob mob, Player player) {
        boolean inWater;
        ResourceLocation entityId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)mob.getType());
        ResourceKey lootTableKey = mob.getLootTable();
        if (lootTableKey == null) {
            return;
        }
        LootParams.Builder paramsBuilder = new LootParams.Builder(level).withParameter(LootContextParams.THIS_ENTITY, (Object)mob).withParameter(LootContextParams.ORIGIN, (Object)mob.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)level.damageSources().generic());
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            paramsBuilder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)serverPlayer);
        }
        LootParams params = paramsBuilder.create(LootContextParamSets.ENTITY);
        LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(lootTableKey);
        ObjectArrayList loots = lootTable.getRandomItems(params);
        for (ItemStack stack : loots) {
            ItemStack remainder = stack.copy();
            if (player.getInventory().add(remainder)) continue;
            ItemEntity itemEntity = new ItemEntity((Level)level, mob.getX(), mob.getY(), mob.getZ(), remainder);
            level.addFreshEntity((Entity)itemEntity);
        }
        Item expNuggetItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"experience_nugget"));
        if (expNuggetItem != null && expNuggetItem != BuiltInRegistries.ITEM.get(ResourceLocation.withDefaultNamespace((String)"air"))) {
            ItemStack expNugget = new ItemStack((ItemLike)expNuggetItem, 1);
            if (!player.getInventory().add(expNugget)) {
                ItemEntity itemEntity = new ItemEntity((Level)level, mob.getX(), mob.getY(), mob.getZ(), expNugget);
                level.addFreshEntity((Entity)itemEntity);
            }
        }
        SimpleParticleType particleType = (inWater = level.getBlockState(mob.blockPosition()).getFluidState().isSource()) ? ParticleTypes.BUBBLE : ParticleTypes.CLOUD;
        level.sendParticles((ParticleOptions)particleType, mob.getX(), mob.getY() + 0.5, mob.getZ(), 15, 0.5, 0.5, 0.5, 0.1);
        level.playSound(null, mob.blockPosition(), SoundEvents.BUCKET_FILL_FISH, SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

