/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.event;

import com.adonis.createfisheryindustry.registry.CreateFisheryItems;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="createfisheryindustry")
public class TetheredEntityHandler {
    private static final double PULL_STRENGTH = 0.3;
    private static final double MAX_PULL_DISTANCE = 50.0;
    private static final double PICKUP_DISTANCE = 1.5;

    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Post event) {
        long tetherEndTime;
        Entity entity = event.getEntity();
        if (entity.level().isClientSide) {
            return;
        }
        if (!(entity instanceof ItemEntity) && !(entity instanceof ExperienceOrb)) {
            return;
        }
        CompoundTag tag = entity.getPersistentData();
        if (!tag.getBoolean("HarpoonTethered")) {
            return;
        }
        long currentTime = entity.level().getGameTime();
        if (currentTime > (tetherEndTime = tag.getLong("TetherEndTime"))) {
            TetheredEntityHandler.cleanupTether(entity, tag);
            return;
        }
        int playerId = tag.getInt("TetherPlayerId");
        Level world = entity.level();
        Entity playerEntity = world.getEntity(playerId);
        if (!(playerEntity instanceof Player)) {
            TetheredEntityHandler.cleanupTether(entity, tag);
            return;
        }
        Player player = (Player)playerEntity;
        Vec3 entityPos = entity.position();
        Vec3 playerPos = player.position().add(0.0, (double)player.getBbHeight() * 0.5, 0.0);
        double distance = entityPos.distanceTo(playerPos);
        if (distance > 50.0) {
            TetheredEntityHandler.cleanupTether(entity, tag, player);
            return;
        }
        if (distance < 1.5) {
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                itemEntity.setPickUpDelay(0);
                entity.setPos(playerPos);
                if (player.getInventory().add(itemEntity.getItem())) {
                    itemEntity.discard();
                    TetheredEntityHandler.resetHarpoonGun(player);
                    return;
                }
            } else if (entity instanceof ExperienceOrb) {
                ExperienceOrb orb = (ExperienceOrb)entity;
                entity.setPos(playerPos);
            }
        }
        Vec3 pullDirection = playerPos.subtract(entityPos).normalize();
        Vec3 currentVelocity = entity.getDeltaMovement();
        double pullSpeed = 0.3 * (1.0 + distance * 0.05);
        pullSpeed = Math.min(pullSpeed, 1.0);
        Vec3 newVelocity = currentVelocity.scale(0.8).add(pullDirection.scale(pullSpeed));
        if (newVelocity.length() > 1.5) {
            newVelocity = newVelocity.normalize().scale(1.5);
        }
        entity.setDeltaMovement(newVelocity);
        entity.hasImpulse = true;
        if (entity.onGround() && newVelocity.y < 0.1) {
            entity.setDeltaMovement(newVelocity.x, 0.2, newVelocity.z);
        }
    }

    private static void cleanupTether(Entity entity, CompoundTag tag) {
        TetheredEntityHandler.cleanupTether(entity, tag, null);
    }

    private static void cleanupTether(Entity entity, CompoundTag tag, Player player) {
        tag.remove("HarpoonTethered");
        tag.remove("TetherPlayerId");
        tag.remove("TetherEndTime");
        if (player != null) {
            TetheredEntityHandler.resetHarpoonGun(player);
        }
    }

    private static void resetHarpoonGun(Player player) {
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        if (mainHand.getItem() == CreateFisheryItems.PNEUMATIC_HARPOON_GUN.get()) {
            TetheredEntityHandler.resetGunState(mainHand, player);
        }
        if (offHand.getItem() == CreateFisheryItems.PNEUMATIC_HARPOON_GUN.get()) {
            TetheredEntityHandler.resetGunState(offHand, player);
        }
    }

    private static void resetGunState(ItemStack itemstack, Player player) {
        CustomData customData = (CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (customData.copyTag().getBoolean("tagPullingItem")) {
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> {
                tag.putBoolean("tagHooked", false);
                tag.putBoolean("tagPullingItem", false);
                tag.remove("tagPulledEntityId");
                tag.remove("tagHookedEntityId");
                tag.remove("xPostion");
                tag.remove("yPostion");
                tag.remove("zPostion");
                tag.remove("AccumulatedAirConsumption");
            });
        }
    }
}

