/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.mixin;

import com.adonis.createfisheryindustry.config.CreateFisheryCommonConfig;
import com.adonis.createfisheryindustry.item.CopperDivingLeggingsItem;
import com.adonis.createfisheryindustry.item.NetheriteDivingLeggingsItem;
import com.simibubi.create.content.equipment.armor.DivingBootsItem;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class}, priority=900)
public class SuperJumpMarkerMixin {
    @Unique
    private boolean cfi_wasOnGround = true;
    @Unique
    private boolean cfi_jumpDetected = false;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void enhanceAndMarkJump(CallbackInfo ci) {
        boolean hasLeggings;
        Player player = (Player)this;
        boolean hasDivingBoots = player.getItemBySlot(EquipmentSlot.FEET).getItem() instanceof DivingBootsItem;
        boolean bl = hasLeggings = player.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof CopperDivingLeggingsItem || player.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof NetheriteDivingLeggingsItem;
        if (!hasDivingBoots || !hasLeggings || !player.isInWater() && !player.isInLava()) {
            this.cfi_wasOnGround = player.onGround();
            return;
        }
        if (this.cfi_wasOnGround && !player.onGround() && player.getDeltaMovement().y > 0.0 && !this.cfi_jumpDetected) {
            double extraPower;
            this.cfi_jumpDetected = true;
            double configJumpPower = CreateFisheryCommonConfig.getDivingBaseJumpPower();
            if (player.isSprinting()) {
                configJumpPower = CreateFisheryCommonConfig.getDivingSprintJumpPower();
            }
            if ((extraPower = configJumpPower - 0.5) > 0.0) {
                Vec3 motion = player.getDeltaMovement();
                player.setDeltaMovement(motion.add(0.0, extraPower, 0.0));
            }
            player.getPersistentData().putBoolean("CFI_SuperJumpActive", true);
            if (!player.getAbilities().instabuild) {
                float hungerCost = (float)CreateFisheryCommonConfig.getDivingJumpHungerCost();
                player.causeFoodExhaustion(hungerCost);
            }
        }
        if (player.onGround()) {
            this.cfi_jumpDetected = false;
        }
        this.cfi_wasOnGround = player.onGround();
    }
}

