/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.procedures;

import com.adonis.createfisheryindustry.entity.TetheredHarpoonEntity;
import com.adonis.createfisheryindustry.registry.CreateFisheryItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OnlyIn(value=Dist.CLIENT)
public class PneumaticHarpoonGunChainsLineProcedure {
    private static final Logger LOGGER = LoggerFactory.getLogger(PneumaticHarpoonGunChainsLineProcedure.class);

    public static void register() {
        NeoForge.EVENT_BUS.addListener(PneumaticHarpoonGunChainsLineProcedure::onRenderLevel);
    }

    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            return;
        }
        for (Player player : level.players()) {
            List hooks;
            ItemStack stack = player.getMainHandItem().getItem() == CreateFisheryItems.PNEUMATIC_HARPOON_GUN.get() ? player.getMainHandItem() : player.getOffhandItem();
            if (stack.isEmpty() || stack.getItem() != CreateFisheryItems.PNEUMATIC_HARPOON_GUN.get() || (hooks = level.getEntitiesOfClass(TetheredHarpoonEntity.class, player.getBoundingBox().inflate(100.0), hook -> hook.getOwner() == player && !hook.isRetrieving())).isEmpty()) continue;
            TetheredHarpoonEntity hook2 = (TetheredHarpoonEntity)((Object)hooks.get(0));
            double targetX = hook2.getX();
            double targetY = hook2.getY();
            double targetZ = hook2.getZ();
            double startX = player.getX();
            double startY = player.getEyeY() - 0.2;
            double startZ = player.getZ();
            double distance = Math.sqrt(Math.pow(startX - targetX, 2.0) + Math.pow(startY - targetY, 2.0) + Math.pow(startZ - targetZ, 2.0));
            int chainCount = (int)Math.ceil(distance * 4.0);
            MultiBufferSource.BufferSource buffer = minecraft.renderBuffers().bufferSource();
            PoseStack poseStack = event.getPoseStack();
            ItemRenderer itemRenderer = minecraft.getItemRenderer();
            ItemStack chains = new ItemStack((ItemLike)CreateFisheryItems.CHAINS.get());
            poseStack.pushPose();
            double camX = minecraft.gameRenderer.getMainCamera().getPosition().x;
            double camY = minecraft.gameRenderer.getMainCamera().getPosition().y;
            double camZ = minecraft.gameRenderer.getMainCamera().getPosition().z;
            poseStack.translate(-camX, -camY, -camZ);
            if (chainCount > 1) {
                for (int i = 0; i < chainCount; ++i) {
                    float t = (float)i / (float)(chainCount - 1);
                    float x = (float)Mth.lerp((double)t, (double)startX, (double)targetX);
                    float y = (float)Mth.lerp((double)t, (double)startY, (double)targetY);
                    float z = (float)Mth.lerp((double)t, (double)startZ, (double)targetZ);
                    BlockPos pos = BlockPos.containing((double)x, (double)y, (double)z);
                    int light = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)pos);
                    poseStack.pushPose();
                    poseStack.translate(x, y, z);
                    Vec3 direction = new Vec3(targetX - startX, targetY - startY, targetZ - startZ).normalize();
                    float yaw = (float)Math.toDegrees(Math.atan2(direction.x, direction.z));
                    float pitch = (float)Math.toDegrees(Math.asin(-direction.y));
                    poseStack.mulPose(Axis.YP.rotationDegrees(yaw));
                    poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
                    poseStack.scale(0.5f, 0.5f, 0.5f);
                    itemRenderer.renderStatic(chains, ItemDisplayContext.FIXED, light, OverlayTexture.NO_OVERLAY, poseStack, (MultiBufferSource)buffer, (Level)level, 0);
                    poseStack.popPose();
                }
            }
            poseStack.popPose();
            buffer.endBatch();
        }
    }
}

