/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear;

import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.nuclearteam.createnuclear.CNCreativeModeTabs;
import net.nuclearteam.createnuclear.CNEffects;
import net.nuclearteam.createnuclear.CNEntityType;
import net.nuclearteam.createnuclear.CNTags;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.content.equipment.armor.AntiRadiationArmorItem;
import net.nuclearteam.createnuclear.content.equipment.armor.CNArmorMaterials;
import net.nuclearteam.createnuclear.content.equipment.cloth.ClothItem;
import net.nuclearteam.createnuclear.content.multiblock.bluePrintItem.ReactorBluePrintItem;
import net.nuclearteam.createnuclear.foundation.utility.TextUtils;

public class CNItems {
    public static final ItemEntry<Item> YELLOWCAKE;
    public static final ItemEntry<Item> RAW_LEAD;
    public static final ItemEntry<Item> RAW_URANIUM;
    public static final ItemEntry<Item> URANIUM_POWDER;
    public static final ItemEntry<Item> STEEL_INGOT;
    public static final ItemEntry<Item> COAL_DUST;
    public static final ItemEntry<Item> GRAPHITE_ROD;
    public static final ItemEntry<Item> LEAD_INGOT;
    public static final ItemEntry<Item> STEEL_NUGGET;
    public static final ItemEntry<Item> URANIUM_ROD;
    public static final ItemEntry<Item> LEAD_NUGGET;
    public static final ItemEntry<Item> GRAPHENE;
    public static final ItemEntry<Item> ENRICHED_YELLOWCAKE;
    public static final AntiRadiationArmorItem.Helmet.DyeItemHelmetList<AntiRadiationArmorItem.Helmet> ANTI_RADIATION_HELMETS;
    public static final AntiRadiationArmorItem.Chestplate.DyeItemChestplateList<AntiRadiationArmorItem.Chestplate> ANTI_RADIATION_CHESTPLATES;
    public static final AntiRadiationArmorItem.Leggings.DyeItemLeggingsList<AntiRadiationArmorItem.Leggings> ANTI_RADIATION_LEGGINGS;
    public static final ItemEntry<? extends AntiRadiationArmorItem.Boot> ANTI_RADIATION_BOOTS;
    public static final ClothItem.DyeItemList<ClothItem> CLOTHS;
    public static final ItemEntry<DeferredSpawnEggItem> SPAWN_WOLF;
    public static final ItemEntry<DeferredSpawnEggItem> SPAWN_CAT;
    public static final ItemEntry<DeferredSpawnEggItem> SPAWN_CHICKEN;
    public static final ItemEntry<ReactorBluePrintItem> REACTOR_BLUEPRINT;

    private static ItemEntry<DeferredSpawnEggItem> registerSpawnEgg(String name, Supplier<? extends EntityType<? extends Mob>> entity, int backgroundColor, int highlightColor, String nameItems) {
        return CreateNuclear.REGISTRATE.item(name, p -> new DeferredSpawnEggItem(entity, backgroundColor, highlightColor, p)).lang(nameItems).model((c, p) -> p.withExistingParent(c.getName(), ResourceLocation.withDefaultNamespace((String)"item/template_spawn_egg"))).register();
    }

    public static void register() {
    }

    static {
        CreateNuclear.REGISTRATE.setCreativeTab(CNCreativeModeTabs.MAIN);
        YELLOWCAKE = CreateNuclear.REGISTRATE.item("yellowcake", Item::new).properties(p -> p.food(new FoodProperties.Builder().nutrition(20).saturationModifier(0.3f).alwaysEdible().effect(new MobEffectInstance(CNEffects.RADIATION.getDelegate(), 600, 2), 1.0f).build())).register();
        RAW_LEAD = CreateNuclear.REGISTRATE.item("raw_lead", Item::new).tag(new TagKey[]{CNTags.forgeItemTag("raw_ores"), CNTags.forgeItemTag("raw_materials"), CNTags.forgeItemTag("raw_materials/lead")}).register();
        RAW_URANIUM = CreateNuclear.REGISTRATE.item("raw_uranium", Item::new).tag(new TagKey[]{CNTags.forgeItemTag("raw_ores"), CNTags.forgeItemTag("raw_materials"), CNTags.forgeItemTag("raw_materials/uranium")}).register();
        URANIUM_POWDER = CreateNuclear.REGISTRATE.item("uranium_powder", Item::new).register();
        STEEL_INGOT = CreateNuclear.REGISTRATE.item("steel_ingot", Item::new).tag(new TagKey[]{CNTags.forgeItemTag("ingots"), CNTags.forgeItemTag("ingots/steel")}).register();
        COAL_DUST = CreateNuclear.REGISTRATE.item("coal_dust", Item::new).tag(new TagKey[]{CNTags.forgeItemTag("dusts"), CNTags.forgeItemTag("coal_dusts")}).register();
        GRAPHITE_ROD = CreateNuclear.REGISTRATE.item("graphite_rod", Item::new).tag(new TagKey[]{CNTags.forgeItemTag("rods"), CNTags.CNItemTags.COOLER.tag}).register();
        LEAD_INGOT = CreateNuclear.REGISTRATE.item("lead_ingot", Item::new).tag(new TagKey[]{CNTags.forgeItemTag("ingots"), CNTags.forgeItemTag("ingots/lead")}).register();
        STEEL_NUGGET = CreateNuclear.REGISTRATE.item("steel_nugget", Item::new).tag(new TagKey[]{CNTags.forgeItemTag("nuggets"), CNTags.forgeItemTag("nuggets/steel")}).register();
        URANIUM_ROD = CreateNuclear.REGISTRATE.item("uranium_rod", Item::new).tag(new TagKey[]{CNTags.forgeItemTag("rods"), CNTags.CNItemTags.FUEL.tag}).register();
        LEAD_NUGGET = CreateNuclear.REGISTRATE.item("lead_nugget", Item::new).tag(new TagKey[]{CNTags.forgeItemTag("nuggets"), CNTags.forgeItemTag("nuggets/lead")}).register();
        GRAPHENE = CreateNuclear.REGISTRATE.item("graphene", Item::new).register();
        ENRICHED_YELLOWCAKE = CreateNuclear.REGISTRATE.item("enriched_yellowcake", Item::new).register();
        ANTI_RADIATION_HELMETS = new AntiRadiationArmorItem.Helmet.DyeItemHelmetList<AntiRadiationArmorItem.Helmet>(color -> {
            String colorName = color.getSerializedName();
            return CreateNuclear.REGISTRATE.item(colorName + "_anti_radiation_helmet", p -> new AntiRadiationArmorItem.Helmet((Item.Properties)p, (DyeColor)color)).tag(new TagKey[]{CNTags.forgeItemTag("helmets"), CNTags.forgeItemTag("armors"), AntiRadiationArmorItem.Helmet.getHelmetTag(colorName), CNTags.CNItemTags.ALL_ANTI_RADIATION_ARMORS.tag, CNTags.CNItemTags.ANTI_RADIATION_HELMET_FULL_DYE.tag}).properties(p -> p.durability(CNArmorMaterials.durabilityForType(ArmorItem.Type.HELMET))).lang(TextUtils.titleCaseConversion(color.getName()) + " Anti Radiation Helmet").model((c, p) -> p.generated((NonNullSupplier)c, new ResourceLocation[]{CreateNuclear.asResource("item/armors/helmets/" + colorName + "_anti_radiation_helmet")})).register();
        });
        ANTI_RADIATION_CHESTPLATES = new AntiRadiationArmorItem.Chestplate.DyeItemChestplateList<AntiRadiationArmorItem.Chestplate>(color -> {
            String colorName = color.getSerializedName();
            return CreateNuclear.REGISTRATE.item(colorName + "_anti_radiation_chestplate", p -> new AntiRadiationArmorItem.Chestplate((Item.Properties)p, (DyeColor)color)).tag(new TagKey[]{CNTags.forgeItemTag("chestplates"), CNTags.forgeItemTag("armors"), AntiRadiationArmorItem.Chestplate.getChestplateTag(colorName), CNTags.CNItemTags.ALL_ANTI_RADIATION_ARMORS.tag, CNTags.CNItemTags.ANTI_RADIATION_CHESTPLATE_FULL_DYE.tag}).properties(p -> p.durability(CNArmorMaterials.durabilityForType(ArmorItem.Type.CHESTPLATE))).lang(TextUtils.titleCaseConversion(color.getName()) + " Anti Radiation Chestplate").model((c, p) -> p.generated((NonNullSupplier)c, new ResourceLocation[]{CreateNuclear.asResource("item/armors/chestplates/" + colorName + "_anti_radiation_chestplate")})).register();
        });
        ANTI_RADIATION_LEGGINGS = new AntiRadiationArmorItem.Leggings.DyeItemLeggingsList<AntiRadiationArmorItem.Leggings>(color -> {
            String colorName = color.getSerializedName();
            return CreateNuclear.REGISTRATE.item(colorName + "_anti_radiation_leggings", p -> new AntiRadiationArmorItem.Leggings((Item.Properties)p, (DyeColor)color)).tag(new TagKey[]{CNTags.forgeItemTag("leggings"), CNTags.forgeItemTag("armors"), AntiRadiationArmorItem.Leggings.getLeggingsTag(colorName), CNTags.CNItemTags.ALL_ANTI_RADIATION_ARMORS.tag, CNTags.CNItemTags.ANTI_RADIATION_LEGGINGS_FULL_DYE.tag}).properties(p -> p.durability(CNArmorMaterials.durabilityForType(ArmorItem.Type.LEGGINGS))).lang(TextUtils.titleCaseConversion(color.getName()) + " Anti Radiation Leggings").model((c, p) -> p.generated((NonNullSupplier)c, new ResourceLocation[]{CreateNuclear.asResource("item/armors/leggings/" + colorName + "_anti_radiation_leggings")})).register();
        });
        ANTI_RADIATION_BOOTS = CreateNuclear.REGISTRATE.item("anti_radiation_boots", AntiRadiationArmorItem.Boot::new).tag(new TagKey[]{CNTags.forgeItemTag("boots"), CNTags.forgeItemTag("armors"), CNTags.CNItemTags.ANTI_RADIATION_BOOTS_DYE.tag, CNTags.CNItemTags.ANTI_RADIATION_ARMOR.tag, CNTags.CNItemTags.ALL_ANTI_RADIATION_ARMORS.tag}).lang("Anti Radiation Boots").properties(p -> p.durability(CNArmorMaterials.durabilityForType(ArmorItem.Type.BOOTS))).model((c, p) -> p.generated((NonNullSupplier)c, new ResourceLocation[]{CreateNuclear.asResource("item/armors/anti_radiation_boots")})).register();
        CLOTHS = new ClothItem.DyeItemList<ClothItem>(color -> {
            String colorName = color.getSerializedName();
            return CreateNuclear.REGISTRATE.item(colorName + "_cloth", p -> new ClothItem((Item.Properties)p, (DyeColor)color)).tag(new TagKey[]{CNTags.CNItemTags.CLOTH.tag}).lang(TextUtils.titleCaseConversion(color.getName()) + " Cloth").model((c, p) -> p.generated((NonNullSupplier)c, new ResourceLocation[]{CreateNuclear.asResource("item/cloth/" + colorName + "_cloth")})).register();
        });
        SPAWN_WOLF = CNItems.registerSpawnEgg("wolf_irradiated_spawn_egg", CNEntityType.IRRADIATED_WOLF, 4343083, 4997675, "Irradiated Wolf Spawn Egg");
        SPAWN_CAT = CNItems.registerSpawnEgg("cat_irradiated_spawn_egg", CNEntityType.IRRADIATED_CAT, 3681305, 7612200, "Irradiated Cat Spawn Egg");
        SPAWN_CHICKEN = CNItems.registerSpawnEgg("chicken_irradiated_spawn_egg", CNEntityType.IRRADIATED_CHICKEN, 7050325, 9779516, "Irradiated Chicken Spawn Egg");
        REACTOR_BLUEPRINT = CreateNuclear.REGISTRATE.item("reactor_blueprint_item", ReactorBluePrintItem::new).lang("Reactor Blueprint").model((c, p) -> p.generated((NonNullSupplier)c, new ResourceLocation[]{CreateNuclear.asResource("item/reactor_blueprint")})).properties(p -> p.stacksTo(1)).register();
    }
}

