/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.contraptions.irradiated.cat;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.nuclearteam.createnuclear.content.contraptions.irradiated.cat.IrradiatedCat;

public class IrradiatedCatRelaxOnOwnerGoal
extends Goal {
    private final IrradiatedCat irradiatedCat;
    @Nullable
    private Player ownerPlayer;
    @Nullable
    private BlockPos goalPos;
    private int onBedTicks;

    public IrradiatedCatRelaxOnOwnerGoal(IrradiatedCat cat) {
        this.irradiatedCat = cat;
    }

    public boolean canUse() {
        if (!this.irradiatedCat.isTame()) {
            return false;
        }
        if (this.irradiatedCat.isOrderedToSit()) {
            return false;
        }
        LivingEntity livingentity = this.irradiatedCat.getOwner();
        if (livingentity instanceof Player) {
            this.ownerPlayer = (Player)livingentity;
            if (!livingentity.isSleeping()) {
                return false;
            }
            if (this.irradiatedCat.distanceToSqr((Entity)this.ownerPlayer) > 100.0) {
                return false;
            }
            BlockPos blockpos = this.ownerPlayer.blockPosition();
            BlockState blockState = this.irradiatedCat.level().getBlockState(blockpos);
        }
        return false;
    }

    private boolean spaceIsOccupied() {
        BlockPos pos = this.goalPos;
        if (pos == null) {
            return false;
        }
        AABB searchArea = new AABB(pos).inflate(2.0);
        for (IrradiatedCat nearbyCat : this.irradiatedCat.level().getEntitiesOfClass(IrradiatedCat.class, searchArea)) {
            if (nearbyCat == this.irradiatedCat || !nearbyCat.isLying() && !nearbyCat.isRelaxStateOne()) continue;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.irradiatedCat.isTame() && !this.irradiatedCat.isOrderedToSit() && this.ownerPlayer != null && this.ownerPlayer.isSleeping() && this.goalPos != null && !this.spaceIsOccupied();
    }

    public void start() {
        if (this.goalPos != null) {
            this.irradiatedCat.setInSittingPose(false);
            this.irradiatedCat.getNavigation().moveTo((double)this.goalPos.getX(), (double)this.goalPos.getY(), (double)this.goalPos.getZ(), (double)1.1f);
        }
    }

    public void stop() {
        this.irradiatedCat.setLying(false);
        float f = this.irradiatedCat.level().getTimeOfDay(1.0f);
        if (this.ownerPlayer.getSleepTimer() >= 100 && (double)f > 0.77 && (double)f < 0.8 && (double)this.irradiatedCat.level().getRandom().nextFloat() < 0.7) {
            this.giveMorningGift();
        }
        this.onBedTicks = 0;
        this.irradiatedCat.setRelaxStateOne(false);
        this.irradiatedCat.getNavigation().stop();
    }

    private void giveMorningGift() {
        RandomSource randomsource = this.irradiatedCat.getRandom();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        blockpos$mutableblockpos.set((Vec3i)(this.irradiatedCat.isLeashed() ? this.irradiatedCat.getLeashHolder().blockPosition() : this.irradiatedCat.blockPosition()));
        this.irradiatedCat.randomTeleport(blockpos$mutableblockpos.getX() + randomsource.nextInt(11) - 5, blockpos$mutableblockpos.getY() + randomsource.nextInt(5) - 2, blockpos$mutableblockpos.getZ() + randomsource.nextInt(11) - 5, false);
        blockpos$mutableblockpos.set((Vec3i)this.irradiatedCat.blockPosition());
        LootTable loottable = this.irradiatedCat.level().getServer().reloadableRegistries().getLootTable(BuiltInLootTables.CAT_MORNING_GIFT);
        LootParams lootparams = new LootParams.Builder((ServerLevel)this.irradiatedCat.level()).withParameter(LootContextParams.ORIGIN, (Object)this.irradiatedCat.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)this.irradiatedCat).create(LootContextParamSets.GIFT);
        for (ItemStack itemstack : loottable.getRandomItems(lootparams)) {
            this.irradiatedCat.level().addFreshEntity((Entity)new ItemEntity(this.irradiatedCat.level(), (double)blockpos$mutableblockpos.getX() - (double)Mth.sin((float)(this.irradiatedCat.yBodyRot * ((float)Math.PI / 180))), (double)blockpos$mutableblockpos.getY(), (double)blockpos$mutableblockpos.getZ() + (double)Mth.cos((float)(this.irradiatedCat.yBodyRot * ((float)Math.PI / 180))), itemstack));
        }
    }

    public void tick() {
        if (this.ownerPlayer != null && this.goalPos != null) {
            this.irradiatedCat.setInSittingPose(false);
            this.irradiatedCat.getNavigation().moveTo((double)this.goalPos.getX(), (double)this.goalPos.getY(), (double)this.goalPos.getZ(), (double)1.1f);
            if (this.irradiatedCat.distanceToSqr((Entity)this.ownerPlayer) < 2.5) {
                ++this.onBedTicks;
                if (this.onBedTicks > this.adjustedTickDelay(16)) {
                    this.irradiatedCat.setLying(true);
                    this.irradiatedCat.setRelaxStateOne(false);
                } else {
                    this.irradiatedCat.lookAt((Entity)this.ownerPlayer, 45.0f, 45.0f);
                    this.irradiatedCat.setRelaxStateOne(true);
                }
            } else {
                this.irradiatedCat.setLying(false);
            }
        }
    }
}

