/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.contraptions.irradiated.chicken;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.nuclearteam.createnuclear.content.contraptions.irradiated.chicken.IrradiatedChicken;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
public class IrradiatedChickenModel<T extends IrradiatedChicken>
extends AgeableListModel<T> {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart beak;
    private final ModelPart redThing;
    private final ModelPart pustule1;
    private final ModelPart pustule2;
    private final ModelPart pustule3;

    public IrradiatedChickenModel(ModelPart root) {
        this.head = root.getChild("head");
        this.beak = root.getChild("beak");
        this.redThing = root.getChild("red_thing");
        this.body = root.getChild("body");
        this.rightLeg = root.getChild("right_leg");
        this.leftLeg = root.getChild("left_leg");
        this.rightWing = root.getChild("right_wing");
        this.leftWing = root.getChild("left_wing");
        this.pustule1 = root.getChild("pustule1");
        this.pustule2 = root.getChild("pustule2");
        this.pustule3 = root.getChild("pustule3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -6.0f, -2.0f, 4.0f, 6.0f, 3.0f), PartPose.offset((float)0.0f, (float)15.0f, (float)-4.0f));
        partDefinition.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(14, 0).addBox(-2.0f, -4.0f, -4.0f, 4.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)15.0f, (float)-4.0f));
        partDefinition.addOrReplaceChild("red_thing", CubeListBuilder.create().texOffs(14, 4).addBox(-1.0f, -2.0f, -3.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)15.0f, (float)-4.0f));
        partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 9).addBox(-3.0f, -4.0f, -3.0f, 6.0f, 8.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)16.0f, (float)0.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeListBuilder cubeListBuilder = CubeListBuilder.create().texOffs(26, 0).addBox(-1.0f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f);
        partDefinition.addOrReplaceChild("right_leg", cubeListBuilder, PartPose.offset((float)-2.0f, (float)19.0f, (float)1.0f));
        partDefinition.addOrReplaceChild("left_leg", cubeListBuilder, PartPose.offset((float)1.0f, (float)19.0f, (float)1.0f));
        partDefinition.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(24, 13).addBox(0.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f), PartPose.offset((float)-4.0f, (float)13.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(24, 13).addBox(-1.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f), PartPose.offset((float)4.0f, (float)13.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("pustule1", CubeListBuilder.create().texOffs(19, 10).addBox(-2.0f, -6.5f, -0.5f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)15.0f, (float)-4.0f, (float)-0.2233f, (float)0.2129f, (float)-0.0479f));
        partDefinition.addOrReplaceChild("pustule2", CubeListBuilder.create().texOffs(19, 10).addBox(-2.0f, 0.3f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-1.45f, (float)12.0f, (float)2.6f, (float)2.2787f, (float)-1.327f, (float)-2.3973f));
        partDefinition.addOrReplaceChild("pustule3", CubeListBuilder.create().texOffs(19, 10).addBox(-1.0f, -1.0f, -0.6f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)1.05f, (float)17.5f, (float)3.1f, (float)0.1981f, (float)-0.1324f, (float)3.0922f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.pustule1.xRot = this.head.xRot;
        this.pustule1.yRot = this.head.yRot;
        this.beak.xRot = this.head.xRot;
        this.beak.yRot = this.head.yRot;
        this.redThing.xRot = this.head.xRot;
        this.redThing.yRot = this.head.yRot;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightWing.zRot = ageInTicks;
        this.leftWing.zRot = -ageInTicks;
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.beak.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.redThing.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightWing.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftWing.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.pustule1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.pustule2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.pustule3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head, (Object)this.beak, (Object)this.redThing, (Object)this.pustule1);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.rightWing, (Object)this.leftWing, (Object)this.pustule2, (Object)this.pustule3);
    }
}

