/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.kinetics.fan.processing;

import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.nuclearteam.createnuclear.CNBlocks;
import net.nuclearteam.createnuclear.CNEffects;
import net.nuclearteam.createnuclear.CNRecipeTypes;
import net.nuclearteam.createnuclear.CNTags;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.content.enriching.campfire.EnrichingCampfireBlock;

public class CNFanProcessingTypes {
    public static final EnrichedType ENRICHED = CNFanProcessingTypes.register("enriched", new EnrichedType());
    private static final Map<String, FanProcessingType> LEGACY_NAME_MAP;

    private static <T extends FanProcessingType> T register(String id, T type) {
        return (T)((FanProcessingType)Registry.register((Registry)CreateBuiltInRegistries.FAN_PROCESSING_TYPE, (ResourceLocation)CreateNuclear.asResource(id), type));
    }

    @Nullable
    public static FanProcessingType ofLegacyName(String name) {
        return LEGACY_NAME_MAP.get(name);
    }

    public static void register() {
    }

    public static FanProcessingType parseLegacy(String str) {
        FanProcessingType type = CNFanProcessingTypes.ofLegacyName(str);
        if (type != null) {
            return type;
        }
        return FanProcessingType.parse((String)str);
    }

    static {
        Object2ReferenceOpenHashMap map = new Object2ReferenceOpenHashMap();
        map.put((Object)"ENRICHED", (Object)ENRICHED);
        map.trim();
        LEGACY_NAME_MAP = map;
    }

    public static class EnrichedType
    implements FanProcessingType {
        public boolean isValidAt(Level level, BlockPos pos) {
            BlockState state = level.getBlockState(pos);
            if (CNTags.CNBlockTags.FAN_PROCESSING_CATALYSTS_ENRICHED.matches(state)) {
                return !state.is((Block)CNBlocks.ENRICHING_CAMPFIRE.get()) || !state.hasProperty((Property)EnrichingCampfireBlock.LIT) || (Boolean)state.getValue((Property)EnrichingCampfireBlock.LIT) != false;
            }
            return false;
        }

        public int getPriority() {
            return 301;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            Optional recipe = CNRecipeTypes.ENRICHED.find(new SingleRecipeInput(stack), level);
            return recipe.isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            Optional recipe = CNRecipeTypes.ENRICHED.find(new SingleRecipeInput(stack), level);
            if (recipe.isPresent()) {
                return RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, recipe.get());
            }
            return null;
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.random.nextInt(8) != 0) {
                return;
            }
            pos = pos.add(VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)level.random, (float)1.0f).multiply(1.0, 0.5, 1.0).normalize().scale((double)0.15f));
            level.addParticle((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, pos.x, pos.y + (double)0.45f, pos.z, 0.0, 0.0, 0.0);
            if (level.random.nextInt(2) != 0) {
                level.addParticle((ParticleOptions)ParticleTypes.FIREWORK, pos.x, pos.y + 0.25, pos.z, 0.0, 0.0, 0.0);
            }
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)0, (int)1205608, (float)random.nextFloat()));
            particleAccess.setAlpha(1.0f);
            if (random.nextFloat() < 0.0078125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.ASH, 0.125f);
            }
            if (random.nextFloat() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.DOLPHIN, 0.125f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.addEffect(new MobEffectInstance(CNEffects.RADIATION.getDelegate(), 10, 0, true, true));
            }
        }
    }
}

