/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.multiblock.bluePrintItem;

import com.simibubi.create.foundation.gui.menu.GhostItemMenu;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.nuclearteam.createnuclear.CNDataComponents;
import net.nuclearteam.createnuclear.CNMenus;
import net.nuclearteam.createnuclear.CNTags;
import net.nuclearteam.createnuclear.content.multiblock.bluePrintItem.PatternData;
import net.nuclearteam.createnuclear.content.multiblock.bluePrintItem.ReactorBluePrintData;
import net.nuclearteam.createnuclear.content.multiblock.bluePrintItem.ReactorBluePrintItem;
import net.nuclearteam.createnuclear.infrastructure.config.CNConfigs;

public class ReactorBluePrintMenu
extends GhostItemMenu<ItemStack> {
    public float heat = 0.0f;
    public int graphiteTime = 5000;
    public int uraniumTime = 3600;
    public int countGraphiteRod = 0;
    public int countUraniumRod = 0;
    public double progress = 0.0;
    public boolean sendUpdate = false;
    private ReactorBluePrintData reactorBluePrintData;

    public ReactorBluePrintMenu(MenuType<?> type, int id, Inventory inv, RegistryFriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    public ReactorBluePrintMenu(MenuType<?> type, int id, Inventory inv, ItemStack contentHolder) {
        super(type, id, inv, (Object)contentHolder);
    }

    public static ReactorBluePrintMenu create(int id, Inventory inv, ItemStack stack) {
        return new ReactorBluePrintMenu((MenuType)CNMenus.REACTOR_BLUEPRINT_MENU.get(), id, inv, stack);
    }

    protected boolean allowRepeats() {
        return false;
    }

    protected void initAndReadInventory(ItemStack contentHolder) {
        super.initAndReadInventory((Object)contentHolder);
        int[][] positions = new int[][]{{3, 0}, {4, 0}, {5, 0}, {2, 1}, {3, 1}, {4, 1}, {5, 1}, {6, 1}, {1, 2}, {2, 2}, {3, 2}, {4, 2}, {5, 2}, {6, 2}, {7, 2}, {0, 3}, {1, 3}, {2, 3}, {3, 3}, {4, 3}, {5, 3}, {6, 3}, {7, 3}, {8, 3}, {0, 4}, {1, 4}, {2, 4}, {3, 4}, {4, 4}, {5, 4}, {6, 4}, {7, 4}, {8, 4}, {0, 5}, {1, 5}, {2, 5}, {3, 5}, {4, 5}, {5, 5}, {6, 5}, {7, 5}, {8, 5}, {1, 6}, {2, 6}, {3, 6}, {4, 6}, {5, 6}, {6, 6}, {7, 6}, {2, 7}, {3, 7}, {4, 7}, {5, 7}, {6, 7}, {3, 8}, {4, 8}, {5, 8}};
        PatternData[] patternData = new PatternData[positions.length];
        ItemStack defaultStack = new ItemStack((ItemLike)Items.GLASS_PANE);
        for (int i = 0; i < positions.length; ++i) {
            patternData[i] = new PatternData(i, defaultStack);
        }
        ReactorBluePrintData defaultPattern = new ReactorBluePrintData(0, 0, (Integer)CNConfigs.common().rods.graphiteRodLifetime.get(), (Integer)CNConfigs.common().rods.uraniumRodLifetime.get(), patternData, patternData);
        this.reactorBluePrintData = (ReactorBluePrintData)contentHolder.getOrDefault(CNDataComponents.REACTOR_BLUE_PRINT_DATA, (Object)defaultPattern);
        for (int i = 0; i < positions.length; ++i) {
            ItemStack stack = this.reactorBluePrintData.pattern()[i].stack().is(CNTags.CNItemTags.COOLER.tag) || this.reactorBluePrintData.pattern()[i].stack().is(CNTags.CNItemTags.FUEL.tag) ? this.reactorBluePrintData.pattern()[i].stack() : ItemStack.EMPTY;
            this.ghostInventory.setStackInSlot(i, stack);
        }
    }

    protected ItemStackHandler createGhostInventory() {
        return ReactorBluePrintItem.getItemStorage((ItemStack)this.contentHolder);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected ItemStack createOnClient(RegistryFriendlyByteBuf extraData) {
        return (ItemStack)ItemStack.STREAM_CODEC.decode((Object)extraData);
    }

    protected void addSlots() {
        this.addPlayerSlots(this.getPlayerInventoryXOffset(), this.getPlayerInventoryYOffset());
        this.addPatternSlots();
    }

    private void addPatternSlots() {
        int[][] positions;
        int startWidth = 31;
        int startHeight = 45;
        int incr = 18;
        int i = 0;
        for (int[] pos : positions = new int[][]{{3, 0}, {4, 0}, {5, 0}, {2, 1}, {3, 1}, {4, 1}, {5, 1}, {6, 1}, {1, 2}, {2, 2}, {3, 2}, {4, 2}, {5, 2}, {6, 2}, {7, 2}, {0, 3}, {1, 3}, {2, 3}, {3, 3}, {4, 3}, {5, 3}, {6, 3}, {7, 3}, {8, 3}, {0, 4}, {1, 4}, {2, 4}, {3, 4}, {4, 4}, {5, 4}, {6, 4}, {7, 4}, {8, 4}, {0, 5}, {1, 5}, {2, 5}, {3, 5}, {4, 5}, {5, 5}, {6, 5}, {7, 5}, {8, 5}, {1, 6}, {2, 6}, {3, 6}, {4, 6}, {5, 6}, {6, 6}, {7, 6}, {2, 7}, {3, 7}, {4, 7}, {5, 7}, {6, 7}, {3, 8}, {4, 8}, {5, 8}}) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.ghostInventory, i, startWidth + incr * pos[0], startHeight + incr * pos[1]));
            ++i;
        }
    }

    protected void saveData(ItemStack contentHolder) {
        int[][] positions = new int[][]{{3, 0}, {4, 0}, {5, 0}, {2, 1}, {3, 1}, {4, 1}, {5, 1}, {6, 1}, {1, 2}, {2, 2}, {3, 2}, {4, 2}, {5, 2}, {6, 2}, {7, 2}, {0, 3}, {1, 3}, {2, 3}, {3, 3}, {4, 3}, {5, 3}, {6, 3}, {7, 3}, {8, 3}, {0, 4}, {1, 4}, {2, 4}, {3, 4}, {4, 4}, {5, 4}, {6, 4}, {7, 4}, {8, 4}, {0, 5}, {1, 5}, {2, 5}, {3, 5}, {4, 5}, {5, 5}, {6, 5}, {7, 5}, {8, 5}, {1, 6}, {2, 6}, {3, 6}, {4, 6}, {5, 6}, {6, 6}, {7, 6}, {2, 7}, {3, 7}, {4, 7}, {5, 7}, {6, 7}, {3, 8}, {4, 8}, {5, 8}};
        PatternData[] patternData = new PatternData[positions.length];
        int countGraphiteRod = 0;
        int countUraniumRod = 0;
        for (int i = 0; i < positions.length; ++i) {
            ItemStack stack = this.ghostInventory.getStackInSlot(i);
            if (!stack.isEmpty() && stack.getCount() >= 1 && stack.getCount() <= 99) {
                if (stack.is(CNTags.CNItemTags.COOLER.tag)) {
                    ++countGraphiteRod;
                }
                if (stack.is(CNTags.CNItemTags.FUEL.tag)) {
                    ++countUraniumRod;
                }
                patternData[i] = new PatternData(i, stack);
                continue;
            }
            patternData[i] = new PatternData(i, new ItemStack((ItemLike)Items.GLASS_PANE));
        }
        ReactorBluePrintData reactorBluePrintData = new ReactorBluePrintData(countGraphiteRod, countUraniumRod, (Integer)CNConfigs.common().rods.graphiteRodLifetime.get(), (Integer)CNConfigs.common().rods.uraniumRodLifetime.get(), patternData, patternData);
        contentHolder.set(CNDataComponents.REACTOR_BLUE_PRINT_DATA, (Object)reactorBluePrintData);
        ReactorBluePrintData newData = new ReactorBluePrintData(countGraphiteRod, countUraniumRod, (Integer)CNConfigs.common().rods.graphiteRodLifetime.get(), (Integer)CNConfigs.common().rods.uraniumRodLifetime.get(), patternData, patternData);
        if (!newData.equals(reactorBluePrintData)) {
            contentHolder.set(CNDataComponents.REACTOR_BLUE_PRINT_DATA, (Object)newData);
        }
    }

    protected int getPlayerInventoryXOffset() {
        return 31;
    }

    protected int getPlayerInventoryYOffset() {
        return 231;
    }

    public boolean stillValid(Player player) {
        return this.playerInventory.getSelected() == this.contentHolder;
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (clickTypeIn == ClickType.THROW) {
            if (slotId >= 0 && slotId < 9) {
                clickTypeIn = ClickType.PICKUP;
                super.clicked(slotId, dragType, clickTypeIn, player);
            }
            return;
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }
}

