/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.multiblock.casing;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.nuclearteam.createnuclear.CNBlockEntityTypes;
import net.nuclearteam.createnuclear.CNBlocks;
import net.nuclearteam.createnuclear.content.multiblock.casing.ReactorCasingEntity;
import net.nuclearteam.createnuclear.content.multiblock.controller.ReactorControllerBlock;
import net.nuclearteam.createnuclear.content.multiblock.controller.ReactorControllerBlockEntity;
import net.nuclearteam.createnuclear.content.multiblock.input.ReactorInput;
import net.nuclearteam.createnuclear.foundation.utility.CreateNuclearLang;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ReactorCasing
extends Block
implements IWrenchable,
IBE<ReactorCasingEntity> {
    private final TypeBlock typeBlock;

    public ReactorCasing(BlockBehaviour.Properties properties, TypeBlock tBlock) {
        super(properties);
        this.typeBlock = tBlock;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        List players = level.players();
        this.FindController(pos, level, players, true);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
        List players = level.players();
        this.FindController(pos, level, players, false);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(state, level, pos, newState, movedByPiston);
        List players = level.players();
        this.FindController(pos, level, players, false);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (player.getItemInHand(InteractionHand.OFF_HAND).is(Blocks.HOPPER.asItem())) {
            level.setBlock(pos, (BlockState)CNBlocks.REACTOR_INPUT.getDefaultState().setValue((Property)ReactorInput.FACING, (Comparable)context.getClickedFace()), 2);
            player.sendSystemMessage((Component)Component.translatable((String)"reactor.update.casing.input"));
        }
        return InteractionResult.SUCCESS;
    }

    public ReactorControllerBlock FindController(BlockPos blockPos, Level level, List<? extends Player> players, boolean first) {
        Vec3i pos = new Vec3i(blockPos.getX(), blockPos.getY(), blockPos.getZ());
        for (int y = pos.getY() - 3; y != pos.getY() + 4; ++y) {
            for (int x = pos.getX() - 5; x != pos.getX() + 5; ++x) {
                for (int z = pos.getZ() - 5; z != pos.getZ() + 5; ++z) {
                    BlockPos newBlock = new BlockPos(x, y, z);
                    if (!level.getBlockState(newBlock).is((Block)CNBlocks.REACTOR_CONTROLLER.get())) continue;
                    ReactorControllerBlock controller = (ReactorControllerBlock)level.getBlockState(newBlock).getBlock();
                    controller.Verify(level.getBlockState(newBlock), newBlock, level, players, first);
                    ReactorControllerBlockEntity entity = (ReactorControllerBlockEntity)controller.getBlockEntity((BlockGetter)level, newBlock);
                    if (!entity.created) continue;
                    return controller;
                }
            }
        }
        return null;
    }

    public Class<ReactorCasingEntity> getBlockEntityClass() {
        return ReactorCasingEntity.class;
    }

    public BlockEntityType<? extends ReactorCasingEntity> getBlockEntityType() {
        return switch (this.typeBlock.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> (BlockEntityType)CNBlockEntityTypes.REACTOR_CORE.get();
            case 0 -> (BlockEntityType)CNBlockEntityTypes.REACTOR_CASING.get();
        };
    }

    public static enum TypeBlock implements StringRepresentable
    {
        CASING,
        CORE;


        public String getSerializedName() {
            return CreateNuclearLang.asId((String)this.name());
        }
    }
}

