/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.multiblock.controller;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.IItemHandler;
import net.nuclearteam.createnuclear.CNBlockEntityTypes;
import net.nuclearteam.createnuclear.CNBlocks;
import net.nuclearteam.createnuclear.CNItems;
import net.nuclearteam.createnuclear.api.multiblock.BlockPattern;
import net.nuclearteam.createnuclear.api.multiblock.TypeMultiblock;
import net.nuclearteam.createnuclear.content.multiblock.CNMultiblock;
import net.nuclearteam.createnuclear.content.multiblock.controller.ReactorControllerBlockEntity;
import net.nuclearteam.createnuclear.content.multiblock.output.ReactorOutput;
import net.nuclearteam.createnuclear.content.multiblock.output.ReactorOutputEntity;
import net.nuclearteam.createnuclear.foundation.block.HorizontalDirectionalReactorBlock;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ReactorControllerBlock
extends HorizontalDirectionalReactorBlock
implements IWrenchable,
IBE<ReactorControllerBlockEntity> {
    public static final BooleanProperty ASSEMBLED = BooleanProperty.create((String)"assembled");

    public ReactorControllerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{ASSEMBLED});
        super.createBlockStateDefinition(builder);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)ASSEMBLED, (Comparable)Boolean.valueOf(false));
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            be.created = false;
        });
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof ReactorControllerBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ReactorControllerBlockEntity controllerBlockEntity = (ReactorControllerBlockEntity)blockEntity;
        ItemStack heldItem = player.getItemInHand(hand);
        if (!((Boolean)state.getValue((Property)ASSEMBLED)).booleanValue()) {
            player.sendSystemMessage((Component)Component.translatable((String)"reactor.info.assembled.none").withStyle(ChatFormatting.RED));
        } else {
            if (heldItem.is((Item)CNItems.REACTOR_BLUEPRINT.get()) && controllerBlockEntity.inventory.getItem(0).isEmpty()) {
                this.withBlockEntityDo((BlockGetter)level, pos, be -> {
                    be.inventory.setStackInSlot(0, heldItem);
                    be.configuredPattern = heldItem;
                    player.setItemInHand(hand, ItemStack.EMPTY);
                });
                return ItemInteractionResult.SUCCESS;
            }
            if (heldItem.isEmpty() && !controllerBlockEntity.inventory.getItem(0).isEmpty()) {
                this.withBlockEntityDo((BlockGetter)level, pos, be -> {
                    player.setItemInHand(hand, be.inventory.getItem(0));
                    be.inventory.setStackInSlot(0, ItemStack.EMPTY);
                    be.configuredPattern = ItemStack.EMPTY;
                    be.total = 0.0;
                    be.rotate(be.getBlockState(), new BlockPos(be.getBlockPos().getX(), be.getBlockPos().getY() + -3, be.getBlockPos().getZ()), be.getLevel(), 0, false);
                    be.notifyUpdate();
                });
                state.setValue((Property)ASSEMBLED, (Comparable)Boolean.valueOf(false));
                return ItemInteractionResult.SUCCESS;
            }
            if (!heldItem.isEmpty() && !controllerBlockEntity.inventory.getItem(0).isEmpty()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.hasBlockEntity() || state.getBlock() == newState.getBlock()) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> ItemHelper.dropContents((Level)worldIn, (BlockPos)pos, (IItemHandler)be.inventory));
        worldIn.removeBlockEntity(pos);
        ReactorControllerBlock controller = (ReactorControllerBlock)state.getBlock();
        controller.Rotate(state, pos.below(3), worldIn, 0);
        List players = worldIn.players();
        for (Player p : players) {
            p.sendSystemMessage((Component)Component.translatable((String)"reactor.info.assembled.destroyer"));
        }
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        if (((Boolean)state.getValue((Property)ASSEMBLED)).booleanValue()) {
            return;
        }
        List players = level.players();
        ReactorControllerBlock controller = (ReactorControllerBlock)state.getBlock();
        controller.Verify(state, pos, level, players, true);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
        ReactorControllerBlock controller = (ReactorControllerBlock)state.getBlock();
        ReactorControllerBlockEntity entity = (ReactorControllerBlockEntity)controller.getBlockEntity((BlockGetter)level, pos);
        if (!entity.created) {
            return;
        }
        controller.Rotate(state, pos.below(3), level, 0);
        List players = level.players();
        for (Player p : players) {
            p.sendSystemMessage((Component)Component.translatable((String)"reactor.info.assembled.creator"));
        }
    }

    public void Verify(BlockState state, BlockPos pos, Level level, List<? extends Player> players, boolean create) {
        ReactorControllerBlock controller = (ReactorControllerBlock)level.getBlockState(pos).getBlock();
        ReactorControllerBlockEntity entity = (ReactorControllerBlockEntity)controller.getBlockEntity((BlockGetter)level, pos);
        BlockPattern<TypeMultiblock> result = CNMultiblock.REGISTRATE_MULTIBLOCK.findStructure(level, pos);
        if (result != null) {
            for (Player player : players) {
                if (!create || entity.created) continue;
                player.sendSystemMessage((Component)Component.translatable((String)"reactor.info.assembled.creator"));
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ASSEMBLED, (Comparable)Boolean.valueOf(true)));
                entity.created = true;
                entity.destroyed = false;
            }
            return;
        }
        for (Player player : players) {
            if (create || entity.destroyed) continue;
            player.sendSystemMessage((Component)Component.translatable((String)"reactor.info.assembled.destroyer"));
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ASSEMBLED, (Comparable)Boolean.valueOf(false)));
            entity.created = false;
            entity.destroyed = true;
            this.Rotate(state, pos.below(3), level, 0);
        }
    }

    public void Rotate(BlockState state, BlockPos pos, Level level, int rotation) {
        if (level.getBlockState(pos).is((Block)CNBlocks.REACTOR_OUTPUT.get())) {
            ReactorOutput block = (ReactorOutput)level.getBlockState(pos).getBlock();
            ReactorOutputEntity entity = (ReactorOutputEntity)block.getBlockEntityType().getBlockEntity((BlockGetter)level, pos);
            if (((Boolean)state.getValue((Property)ASSEMBLED)).booleanValue() && rotation != 0) {
                entity.speed = rotation;
                entity.setSpeed(Math.abs(entity.speed));
            } else {
                entity.setSpeed(0);
                entity.speed = 0;
            }
            entity.updateSpeed = true;
            entity.updateGeneratedRotation();
            entity.setSpeed(rotation);
        }
    }

    public Class<ReactorControllerBlockEntity> getBlockEntityClass() {
        return ReactorControllerBlockEntity.class;
    }

    public BlockEntityType<? extends ReactorControllerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CNBlockEntityTypes.REACTOR_CONTROLLER.get();
    }
}

