/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.multiblock.reactorCooler;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.nuclearteam.createnuclear.CNBlocks;
import net.nuclearteam.createnuclear.content.multiblock.controller.ReactorControllerBlock;
import net.nuclearteam.createnuclear.content.multiblock.controller.ReactorControllerBlockEntity;

public class ReactorCooler
extends Block
implements IWrenchable {
    public ReactorCooler(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        List players = level.players();
        this.FindController(pos, level, players, true);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
        List players = level.players();
        this.FindController(pos, level, players, false);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(state, level, pos, newState, movedByPiston);
        List players = level.players();
        this.FindController(pos, level, players, false);
    }

    public ReactorControllerBlock FindController(BlockPos blockPos, Level level, List<? extends Player> players, boolean first) {
        Vec3i pos = new Vec3i(blockPos.getX(), blockPos.getY(), blockPos.getZ());
        for (int y = pos.getY() - 3; y != pos.getY() + 4; ++y) {
            for (int x = pos.getX() - 5; x != pos.getX() + 5; ++x) {
                for (int z = pos.getZ() - 5; z != pos.getZ() + 5; ++z) {
                    BlockPos newBlock = new BlockPos(x, y, z);
                    if (!level.getBlockState(newBlock).is((Block)CNBlocks.REACTOR_CONTROLLER.get())) continue;
                    ReactorControllerBlock controller = (ReactorControllerBlock)level.getBlockState(newBlock).getBlock();
                    controller.Verify(level.getBlockState(newBlock), newBlock, level, players, first);
                    ReactorControllerBlockEntity entity = (ReactorControllerBlockEntity)controller.getBlockEntity((BlockGetter)level, newBlock);
                    if (!entity.created) continue;
                    return controller;
                }
            }
        }
        return null;
    }
}

