/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.foundation.utility;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class RenderHelper {
    private static float lastAlpha = Float.NaN;
    private static float lastCoverage = Float.NaN;
    private static boolean lastFirstPerson = false;

    public static void renderOverlay(GuiGraphics graphics, ResourceLocation texture, float alpha, float coverage, boolean onlyFirstPerson) {
        boolean isFirstPerson = Minecraft.getInstance().options.getCameraType().isFirstPerson();
        if (onlyFirstPerson && !isFirstPerson) {
            return;
        }
        lastAlpha = alpha;
        lastCoverage = coverage;
        lastFirstPerson = isFirstPerson;
        int width = graphics.guiWidth();
        int height = graphics.guiHeight();
        graphics.setColor(1.0f, 1.0f, 1.0f, alpha);
        RenderSystem.enableBlend();
        if (coverage != 1.0f) {
            graphics.pose().pushPose();
            graphics.pose().translate((float)width / 2.0f, (float)height / 2.0f, 0.0f);
            graphics.pose().translate((float)(-width) / 2.0f, (float)(-height) / 2.0f, 0.0f);
            graphics.blit(texture, 0, 0, -90, 0.0f, 0.0f, width, height, width, height);
            graphics.pose().popPose();
        }
        if (coverage == 1.0f) {
            graphics.blit(texture, 0, 0, -90, 0.0f, 0.0f, width, height, width, height);
        }
        RenderSystem.disableBlend();
    }

    public static void renderOverlay(GuiGraphics graphics, ResourceLocation texture, float alpha) {
        RenderHelper.renderOverlay(graphics, texture, alpha, 1.0f, false);
    }

    public static void renderFirstPersonOverlay(GuiGraphics graphics, ResourceLocation texture, float alpha, float coverage) {
        RenderHelper.renderOverlay(graphics, texture, alpha, coverage, true);
    }

    public static void renderTextureOverlay(GuiGraphics graphics, ResourceLocation texture, float alpha) {
        int width = graphics.guiWidth();
        int height = graphics.guiHeight();
        graphics.setColor(1.0f, 1.0f, 1.0f, alpha);
        RenderSystem.enableBlend();
        graphics.blit(texture, 0, 0, -90, 0.0f, 0.0f, width, height, width, height);
        RenderSystem.disableBlend();
    }
}

