/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.infrastructure.worldgen;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.infrastructure.worldgen.CNPlacedFeatures;

public class CNBiomeModifiers {
    public static final ResourceKey<BiomeModifier> URANIUM_ORE = CNBiomeModifiers.key("uranium_ore");
    public static final ResourceKey<BiomeModifier> LEAD_ORE = CNBiomeModifiers.key("lead_ore");
    public static final ResourceKey<BiomeModifier> STRIATED_ORES_OVERWORLD = CNBiomeModifiers.key("striated_ores_overworld");

    private static ResourceKey<BiomeModifier> key(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)CreateNuclear.asResource(name));
    }

    public static void bootstrap(BootstrapContext<BiomeModifier> ctx) {
        HolderGetter biomeLookup = ctx.lookup(Registries.BIOME);
        HolderSet.Named isOverworld = biomeLookup.getOrThrow(BiomeTags.IS_OVERWORLD);
        HolderGetter featureLookup = ctx.lookup(Registries.PLACED_FEATURE);
        Holder.Reference uraniumOre = featureLookup.getOrThrow(CNPlacedFeatures.URANIUM_ORE);
        Holder.Reference leadOre = featureLookup.getOrThrow(CNPlacedFeatures.LEAD_ORE);
        Holder.Reference striatedOresOverworld = featureLookup.getOrThrow(CNPlacedFeatures.STRIATED_ORES_OVERWORLD);
        ctx.register(URANIUM_ORE, (Object)CNBiomeModifiers.addOre((HolderSet<Biome>)isOverworld, (Holder<PlacedFeature>)uraniumOre));
        ctx.register(LEAD_ORE, (Object)CNBiomeModifiers.addOre((HolderSet<Biome>)isOverworld, (Holder<PlacedFeature>)leadOre));
        ctx.register(STRIATED_ORES_OVERWORLD, (Object)CNBiomeModifiers.addOre((HolderSet<Biome>)isOverworld, (Holder<PlacedFeature>)striatedOresOverworld));
    }

    private static BiomeModifiers.AddFeaturesBiomeModifier addOre(HolderSet<Biome> biomes, Holder<PlacedFeature> feature) {
        return new BiomeModifiers.AddFeaturesBiomeModifier(biomes, (HolderSet)HolderSet.direct((Holder[])new Holder[]{feature}), GenerationStep.Decoration.UNDERGROUND_ORES);
    }
}

