/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.infrastructure.worldgen;

import com.simibubi.create.infrastructure.worldgen.AllFeatures;
import com.simibubi.create.infrastructure.worldgen.LayerPattern;
import com.simibubi.create.infrastructure.worldgen.LayeredOreConfiguration;
import com.simibubi.create.infrastructure.worldgen.LayeredOreFeature;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.nuclearteam.createnuclear.CNBlocks;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.infrastructure.worldgen.CNLayerPatterns;

public class CNConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> URANIUM_ORE = CNConfiguredFeatures.key("uranium_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LEAD_ORE = CNConfiguredFeatures.key("lead_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> STRIATED_ORES_OVERWORLD = CNConfiguredFeatures.key("striated_ores_overworld");

    private static ResourceKey<ConfiguredFeature<?, ?>> key(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)CreateNuclear.asResource(name));
    }

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> ctx) {
        TagMatchTest stoneOreReplaceable = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateOreReplaceables = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        List<OreConfiguration.TargetBlockState> uraniumTargetStates = List.of(OreConfiguration.target((RuleTest)stoneOreReplaceable, (BlockState)CNBlocks.URANIUM_ORE.getDefaultState()), OreConfiguration.target((RuleTest)deepslateOreReplaceables, (BlockState)CNBlocks.DEEPSLATE_URANIUM_ORE.getDefaultState()));
        FeatureUtils.register(ctx, URANIUM_ORE, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(uraniumTargetStates, 7));
        List<OreConfiguration.TargetBlockState> leadTargetStates = List.of(OreConfiguration.target((RuleTest)stoneOreReplaceable, (BlockState)CNBlocks.LEAD_ORE.getDefaultState()), OreConfiguration.target((RuleTest)deepslateOreReplaceables, (BlockState)CNBlocks.DEEPSLATE_LEAD_ORE.getDefaultState()));
        FeatureUtils.register(ctx, LEAD_ORE, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(leadTargetStates, 7));
        List<LayerPattern> overworldLayerPatterns = List.of((LayerPattern)CNLayerPatterns.AUTUNITE.get());
        FeatureUtils.register(ctx, STRIATED_ORES_OVERWORLD, (Feature)((LayeredOreFeature)AllFeatures.LAYERED_ORE.get()), (FeatureConfiguration)new LayeredOreConfiguration(overworldLayerPatterns, 32, 0.0f));
    }
}

