/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import samebutdifferent.ecologics.entity.CoconutCrab;
import samebutdifferent.ecologics.platform.ConfigPlatformHelper;
import samebutdifferent.ecologics.registry.ModBlocks;
import samebutdifferent.ecologics.registry.ModEntityTypes;
import samebutdifferent.ecologics.registry.ModSoundEvents;

public class HangingCoconutBlock
extends FallingBlock
implements BonemealableBlock {
    public static final MapCodec<HangingCoconutBlock> CODEC = HangingCoconutBlock.simpleCodec(HangingCoconutBlock::new);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_2;
    protected static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), Block.box((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0)};

    public HangingCoconutBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return CODEC;
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState aboveState = pLevel.getBlockState(pPos.above());
        return aboveState.is(ModBlocks.COCONUT_LEAVES);
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing == Direction.UP && !this.canSurvive(pState, (LevelReader)pLevel, pCurrentPos) && (Integer)pState.getValue((Property)AGE) < 2) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return true;
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        int age = (Integer)pState.getValue((Property)AGE);
        if (pRandom.nextInt(3) == 0) {
            if (age < 2) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            } else if (pPos.getY() >= pLevel.getMinBuildHeight() && HangingCoconutBlock.isFree((BlockState)pLevel.getBlockState(pPos.below()))) {
                FallingBlockEntity fallingblockentity = FallingBlockEntity.fall((Level)pLevel, (BlockPos)pPos, (BlockState)pLevel.getBlockState(pPos));
                this.falling(fallingblockentity);
                pLevel.removeBlock(pPos, false);
            }
        }
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_AGE[(Integer)pState.getValue((Property)AGE)];
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 2;
    }

    public boolean isBonemealSuccess(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void performBonemeal(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)AGE, (Comparable)Integer.valueOf((Integer)pState.getValue((Property)AGE) + 1)), 2);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{AGE});
    }

    public boolean isPathfindable(BlockState pState, PathComputationType pType) {
        return false;
    }

    protected void falling(FallingBlockEntity pEntity) {
        pEntity.setHurtsEntities(2.0f, 40);
    }

    public DamageSource getFallDamageSource(Entity entity) {
        return entity.damageSources().fallingBlock(entity);
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRand) {
        if (pRand.nextInt(16) == 0 && (Integer)pState.getValue((Property)AGE) == 2) {
            double x = (double)pPos.getX() + pRand.nextDouble();
            double y = (double)pPos.getY() - 0.05;
            double z = (double)pPos.getZ() + pRand.nextDouble();
            pLevel.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, pState), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public int getDustColor(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 3873032;
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRand) {
        if (pLevel.isEmptyBlock(pPos.above()) && pPos.getY() >= pLevel.getMinBuildHeight() && HangingCoconutBlock.isFree((BlockState)pLevel.getBlockState(pPos.below()))) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.fall((Level)pLevel, (BlockPos)pPos, (BlockState)pLevel.getBlockState(pPos));
            this.falling(fallingblockentity);
            pLevel.removeBlock(pPos, false);
        }
    }

    public void onBrokenAfterFall(Level pLevel, BlockPos pPos, FallingBlockEntity pFallingBlock) {
        pLevel.playSound(null, pPos, ModSoundEvents.COCONUT_SMASH, SoundSource.BLOCKS, 0.7f, 0.9f + pLevel.getRandom().nextFloat() * 0.2f);
        if ((double)pLevel.random.nextFloat() <= ConfigPlatformHelper.coconutCrabSpawnChance()) {
            CoconutCrab coconutCrab = (CoconutCrab)ModEntityTypes.COCONUT_CRAB.create(pLevel);
            coconutCrab.setPos(pPos.getX(), pPos.getY(), pPos.getZ());
            pLevel.addFreshEntity((Entity)coconutCrab);
        } else {
            Block.dropResources((BlockState)pFallingBlock.getBlockState(), (Level)pLevel, (BlockPos)pPos);
        }
    }
}

