/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import samebutdifferent.ecologics.block.PotBlock;
import samebutdifferent.ecologics.registry.ModBlockEntityTypes;

public class PotBlockEntity
extends BlockEntity
implements Clearable {
    private NonNullList<ItemStack> items = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);

    public PotBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(ModBlockEntityTypes.POT, pWorldPosition, pBlockState);
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public boolean addItem(ItemStack pStack) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.items.get(i);
            if (!itemstack.isEmpty()) continue;
            this.items.set(i, (Object)pStack.split(1));
            this.markUpdated();
            PotBlock.signalItemAdded(this.getLevel(), this.getBlockPos(), this.getBlockState());
            return true;
        }
        return false;
    }

    private void markUpdated() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public void clearContent() {
        this.items.clear();
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider provider) {
        super.loadAdditional(pTag, provider);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)provider);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider provider) {
        super.saveAdditional(pTag, provider);
        ContainerHelper.saveAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)provider);
    }

    public int getRedstoneSignal() {
        int signal = 0;
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            ++signal;
        }
        return signal;
    }
}

