/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.client.model;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import samebutdifferent.ecologics.entity.CoconutCrab;

@OnlyIn(value=Dist.CLIENT)
public class CoconutCrabModel
extends HierarchicalModel<CoconutCrab> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)"coconut_crab"), "main");
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart shell;
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftMiddleLeg;
    private final ModelPart rightMiddleLeg;
    private final ModelPart rightClaw;
    private final ModelPart leftClaw;

    public CoconutCrabModel(ModelPart root) {
        super(RenderType::entityCutoutNoCull);
        this.root = root.getChild("root");
        this.head = this.root.getChild("head");
        this.shell = this.root.getChild("shell");
        this.leftHindLeg = this.root.getChild("leftHindLeg");
        this.rightHindLeg = this.root.getChild("rightHindLeg");
        this.leftFrontLeg = this.root.getChild("leftFrontLeg");
        this.rightFrontLeg = this.root.getChild("rightFrontLeg");
        this.leftMiddleLeg = this.root.getChild("leftMiddleLeg");
        this.rightMiddleLeg = this.root.getChild("rightMiddleLeg");
        this.rightClaw = this.root.getChild("rightClaw");
        this.leftClaw = this.root.getChild("leftClaw");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create().texOffs(0, 24).addBox(-3.5f, -9.0f, -4.0f, 7.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition shell = root.addOrReplaceChild("shell", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -6.0f, -8.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.4f, (float)6.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition leftClaw = root.addOrReplaceChild("leftClaw", CubeListBuilder.create(), PartPose.offset((float)3.2277f, (float)-4.1522f, (float)-5.5809f));
        PartDefinition cube_r1 = leftClaw.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(31, 36).addBox(-3.0f, -4.0f, -3.0f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.2723f, (float)2.1522f, (float)0.5809f, (float)0.0f, (float)-0.3054f, (float)-0.5236f));
        PartDefinition rightClaw = root.addOrReplaceChild("rightClaw", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = rightClaw.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(34, 28).addBox(-2.3986f, -2.0f, -3.9074f, 6.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.9345f, (float)-3.4055f, (float)-4.2544f, (float)0.0f, (float)0.3054f, (float)0.5236f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(36, 0).addBox(-2.5f, -2.25f, -4.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.25f, (float)-4.0f));
        PartDefinition eyes = head.addOrReplaceChild("eyes", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -1.5f, 0.0f, 5.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.75f, (float)-4.0f));
        PartDefinition rightMiddleLeg = root.addOrReplaceChild("rightMiddleLeg", CubeListBuilder.create().texOffs(24, 24).addBox(-15.0f, -2.0f, -1.0f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-6.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition leftMiddleLeg = root.addOrReplaceChild("leftMiddleLeg", CubeListBuilder.create().texOffs(24, 24).mirror().addBox(5.0f, -2.0f, -1.0f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.0f, (float)-6.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition rightFrontLeg = root.addOrReplaceChild("rightFrontLeg", CubeListBuilder.create().texOffs(24, 24).addBox(-15.0f, -2.0f, -2.0f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-6.0f, (float)-1.0f, (float)0.0f, (float)-0.2618f, (float)-0.3927f));
        PartDefinition leftFrontLeg = root.addOrReplaceChild("leftFrontLeg", CubeListBuilder.create().texOffs(24, 24).mirror().addBox(5.0f, -2.0f, -2.0f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.0f, (float)-6.0f, (float)-1.0f, (float)0.0f, (float)0.2618f, (float)0.3927f));
        PartDefinition rightHindLeg = root.addOrReplaceChild("rightHindLeg", CubeListBuilder.create().texOffs(24, 24).addBox(-15.0f, -2.0f, 0.0f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-6.0f, (float)-1.0f, (float)0.0f, (float)0.2618f, (float)-0.3927f));
        PartDefinition leftHindLeg = root.addOrReplaceChild("leftHindLeg", CubeListBuilder.create().texOffs(24, 24).mirror().addBox(5.0f, -2.0f, 0.0f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.0f, (float)-6.0f, (float)-1.0f, (float)0.0f, (float)-0.2618f, (float)0.3927f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(CoconutCrab entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.shell.visible = entity.hasCoconut();
        float swingSlowdownFactor = 0.2f;
        this.shell.xRot += Mth.cos((float)((float)(Math.toRadians(-360.0) + (double)limbSwing))) * swingSlowdownFactor * limbSwingAmount;
        this.shell.zRot += Mth.cos((float)((float)(Math.toRadians(-60.0) + (double)limbSwing))) * swingSlowdownFactor * limbSwingAmount;
        float legLimbSwingAmount = Math.min(limbSwingAmount, 0.6f);
        this.leftHindLeg.yRot += -Mth.cos((float)((float)(Math.toRadians(-80.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.leftHindLeg.zRot += Mth.cos((float)((float)(Math.toRadians(-40.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.rightHindLeg.yRot += -Mth.cos((float)((float)(Math.toRadians(-80.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.rightHindLeg.zRot += Mth.cos((float)((float)(Math.toRadians(-40.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.leftFrontLeg.yRot += Mth.sin((float)((float)(Math.toRadians(-80.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.leftFrontLeg.zRot += -Mth.sin((float)((float)(Math.toRadians(-40.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.rightFrontLeg.yRot += Mth.sin((float)((float)(Math.toRadians(-80.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.rightFrontLeg.zRot += -Mth.sin((float)((float)(Math.toRadians(-40.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.leftMiddleLeg.yRot += Mth.cos((float)((float)(Math.toRadians(-120.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.leftMiddleLeg.zRot += -Mth.cos((float)((float)(Math.toRadians(-80.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.rightMiddleLeg.yRot += Mth.cos((float)((float)(Math.toRadians(-120.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.rightMiddleLeg.zRot += -Mth.cos((float)((float)(Math.toRadians(-80.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.leftClaw.xRot += -Mth.cos((float)((float)(Math.toRadians(-20.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.leftClaw.zRot += -Mth.cos((float)((float)(Math.toRadians(-20.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.rightClaw.xRot += Mth.cos((float)((float)(Math.toRadians(-40.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.rightClaw.zRot += Mth.cos((float)((float)(Math.toRadians(-40.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
    }

    public ModelPart root() {
        return this.root;
    }
}

