/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.registry;

import java.util.ArrayList;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Block;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;
import samebutdifferent.ecologics.entity.ModBoat;
import samebutdifferent.ecologics.item.CoconutSliceItem;
import samebutdifferent.ecologics.item.ModBoatItem;
import samebutdifferent.ecologics.item.SandcastleBlockItem;
import samebutdifferent.ecologics.registry.ModBlocks;
import samebutdifferent.ecologics.registry.ModEntityTypes;
import samebutdifferent.ecologics.registry.ModJukeboxSongs;

public class ModItems {
    public static final ArrayList<Pair<ResourceLocation, Item>> ITEMS = new ArrayList();
    public static final Item COCONUT_SLICE = ModItems.registerItem("coconut_slice", new CoconutSliceItem(new Item.Properties().food(Foods.SWEET_BERRIES)));
    public static final Item CRAB_MEAT = ModItems.registerItem("crab_meat", new Item(new Item.Properties().food(Foods.COOKED_RABBIT)));
    public static final Item TROPICAL_STEW = ModItems.registerItem("tropical_stew", new CoconutSliceItem(new Item.Properties().stacksTo(1).food(Foods.RABBIT_STEW)));
    public static final Item PRICKLY_PEAR = ModItems.registerItem("prickly_pear", new Item(new Item.Properties().food(Foods.APPLE)));
    public static final Item COOKED_PRICKLY_PEAR = ModItems.registerItem("cooked_prickly_pear", new Item(new Item.Properties().food(Foods.APPLE)));
    public static final Item WALNUT = ModItems.registerItem("walnut", new Item(new Item.Properties().food(new FoodProperties.Builder().nutrition(1).saturationModifier(0.0f).fast().build())));
    public static final Item CRAB_CLAW = ModItems.registerItem("crab_claw", (Item)new ShearsItem(new Item.Properties().durability(50)));
    public static final Item COCONUT_HUSK = ModItems.registerItem("coconut_husk", new Item(new Item.Properties()));
    public static final Item PENGUIN_FEATHER = ModItems.registerItem("penguin_feather", new Item(new Item.Properties()));
    public static final Item SANDCASTLE = ModItems.registerItem("sandcastle", (Item)new SandcastleBlockItem());
    public static final Item MUSIC_DISC_COCONUT = ModItems.registerItem("music_disc_coconut", new Item(new Item.Properties().stacksTo(1).rarity(Rarity.RARE).jukeboxPlayable(ModJukeboxSongs.COCONUT)));
    public static final Item COCONUT_CRAB_SPAWN_EGG = ModItems.registerItem("coconut_crab_spawn_egg", (Item)new SpawnEggItem(ModEntityTypes.COCONUT_CRAB, 15686450, 0x593333, new Item.Properties()));
    public static final Item PENGUIN_SPAWN_EGG = ModItems.registerItem("penguin_spawn_egg", (Item)new SpawnEggItem(ModEntityTypes.PENGUIN, 0x141414, 0xF9F9F9, new Item.Properties()));
    public static final Item SQUIRREL_SPAWN_EGG = ModItems.registerItem("squirrel_spawn_egg", (Item)new SpawnEggItem(ModEntityTypes.SQUIRREL, 10051392, 15720061, new Item.Properties()));
    public static final Item COCONUT_SIGN = ModItems.registerItem("coconut_sign", (Item)new SignItem(new Item.Properties().stacksTo(16), ModBlocks.COCONUT_SIGN, ModBlocks.COCONUT_WALL_SIGN));
    public static final Item COCONUT_HANGING_SIGN = ModItems.registerItem("coconut_hanging_sign", (Item)new HangingSignItem(ModBlocks.COCONUT_HANGING_SIGN, ModBlocks.COCONUT_WALL_HANGING_SIGN, new Item.Properties().stacksTo(16)));
    public static final Item WALNUT_SIGN = ModItems.registerItem("walnut_sign", (Item)new SignItem(new Item.Properties().stacksTo(16), ModBlocks.WALNUT_SIGN, ModBlocks.WALNUT_WALL_SIGN));
    public static final Item WALNUT_HANGING_SIGN = ModItems.registerItem("walnut_hanging_sign", (Item)new HangingSignItem(ModBlocks.WALNUT_HANGING_SIGN, ModBlocks.WALNUT_WALL_HANGING_SIGN, new Item.Properties().stacksTo(16)));
    public static final Item AZALEA_SIGN = ModItems.registerItem("azalea_sign", (Item)new SignItem(new Item.Properties().stacksTo(16), ModBlocks.AZALEA_SIGN, ModBlocks.AZALEA_WALL_SIGN));
    public static final Item AZALEA_HANGING_SIGN = ModItems.registerItem("azalea_hanging_sign", (Item)new HangingSignItem(ModBlocks.AZALEA_HANGING_SIGN, ModBlocks.AZALEA_WALL_HANGING_SIGN, new Item.Properties().stacksTo(16)));
    public static final Item FLOWERING_AZALEA_SIGN = ModItems.registerItem("flowering_azalea_sign", (Item)new SignItem(new Item.Properties().stacksTo(16), ModBlocks.FLOWERING_AZALEA_SIGN, ModBlocks.FLOWERING_AZALEA_WALL_SIGN));
    public static final Item FLOWERING_AZALEA_HANGING_SIGN = ModItems.registerItem("flowering_azalea_hanging_sign", (Item)new HangingSignItem(ModBlocks.FLOWERING_AZALEA_HANGING_SIGN, ModBlocks.FLOWERING_AZALEA_WALL_HANGING_SIGN, new Item.Properties().stacksTo(16)));
    public static final Item COCONUT_BOAT = ModItems.registerItem("coconut_boat", (Item)new ModBoatItem(false, ModBoat.Type.COCONUT, new Item.Properties().stacksTo(1)));
    public static final Item WALNUT_BOAT = ModItems.registerItem("walnut_boat", (Item)new ModBoatItem(false, ModBoat.Type.WALNUT, new Item.Properties().stacksTo(1)));
    public static final Item AZALEA_BOAT = ModItems.registerItem("azalea_boat", (Item)new ModBoatItem(false, ModBoat.Type.AZALEA, new Item.Properties().stacksTo(1)));
    public static final Item FLOWERING_AZALEA_BOAT = ModItems.registerItem("flowering_azalea_boat", (Item)new ModBoatItem(false, ModBoat.Type.FLOWERING_AZALEA, new Item.Properties().stacksTo(1)));
    public static final Item COCONUT_CHEST_BOAT = ModItems.registerItem("coconut_chest_boat", (Item)new ModBoatItem(true, ModBoat.Type.COCONUT, new Item.Properties().stacksTo(1)));
    public static final Item WALNUT_CHEST_BOAT = ModItems.registerItem("walnut_chest_boat", (Item)new ModBoatItem(true, ModBoat.Type.WALNUT, new Item.Properties().stacksTo(1)));
    public static final Item AZALEA_CHEST_BOAT = ModItems.registerItem("azalea_chest_boat", (Item)new ModBoatItem(true, ModBoat.Type.AZALEA, new Item.Properties().stacksTo(1)));
    public static final Item FLOWERING_AZALEA_CHEST_BOAT = ModItems.registerItem("flowering_azalea_chest_boat", (Item)new ModBoatItem(true, ModBoat.Type.FLOWERING_AZALEA, new Item.Properties().stacksTo(1)));

    public static void init() {
        for (Triplet<ResourceLocation, Block, Boolean> triplet : ModBlocks.BLOCKS) {
            if (!((Boolean)triplet.getC()).booleanValue()) continue;
            ModItems.registerItem(((ResourceLocation)triplet.getA()).getPath(), (Item)new BlockItem((Block)triplet.getB(), new Item.Properties()));
        }
        for (Pair pair : ITEMS) {
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)((ResourceLocation)pair.getA()), (Object)((Item)pair.getB()));
        }
    }

    public static Item registerItem(String name, Item item) {
        ITEMS.add((Pair<ResourceLocation, Item>)new Pair((Object)ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)name), (Object)item));
        return item;
    }
}

