/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.client;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.client.ClientBuiltPool;
import fzzyhmstrs.emi_loot.client.ClientRawPool;
import fzzyhmstrs.emi_loot.client.LootReceiver;
import fzzyhmstrs.emi_loot.util.ConditionalStack;
import fzzyhmstrs.emi_loot.util.TextKey;
import io.netty.handler.codec.DecoderException;
import it.unimi.dsi.fastutil.floats.Float2ObjectArrayMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public abstract class AbstractTextKeyParsingClientLootTable<T extends LootReceiver>
implements LootReceiver {
    private final Map<List<TextKey>, ClientRawPool> rawItems;
    public List<ClientBuiltPool> builtItems;

    public AbstractTextKeyParsingClientLootTable() {
        this.rawItems = new HashMap<List<TextKey>, ClientRawPool>();
    }

    public AbstractTextKeyParsingClientLootTable(Map<List<TextKey>, ClientRawPool> map) {
        this.rawItems = map;
    }

    static ResourceLocation getIdFromBuf(FriendlyByteBuf buf) {
        String idToParse = buf.readUtf();
        if (idToParse.contains(":")) {
            return ResourceLocation.parse((String)idToParse);
        }
        if (idToParse.startsWith("b/")) {
            return ResourceLocation.parse((String)("blocks/" + idToParse.substring(2)));
        }
        if (idToParse.startsWith("e/")) {
            return ResourceLocation.parse((String)("entities/" + idToParse.substring(2)));
        }
        if (idToParse.startsWith("c/")) {
            return ResourceLocation.parse((String)("chests/" + idToParse.substring(2)));
        }
        if (idToParse.startsWith("g/")) {
            return ResourceLocation.parse((String)("gameplay/" + idToParse.substring(2)));
        }
        if (idToParse.startsWith("a/")) {
            return ResourceLocation.parse((String)("archaeology/" + idToParse.substring(2)));
        }
        return ResourceLocation.parse((String)idToParse);
    }

    abstract void getSpecialTextKeyList(Level var1, Block var2, List<Tuple<Integer, Component>> var3);

    public void build(Level world, Block block) {
        boolean bl = BuiltInRegistries.BLOCK.wrapAsHolder((Object)block).is(BlockTags.SLABS);
        LinkedHashMap<List, Object2FloatMap> builderItems = new LinkedHashMap<List, Object2FloatMap>();
        this.rawItems.forEach((list, pool) -> {
            ArrayList<Tuple<Integer, Component>> applyToAllList = new ArrayList<Tuple<Integer, Component>>();
            this.getSpecialTextKeyList(world, block, applyToAllList);
            for (TextKey textKey : list) {
                Component text = textKey.processText();
                applyToAllList.add((Tuple<Integer, Component>)new Tuple((Object)textKey.index(), (Object)text));
            }
            pool.map().forEach((poolList, poolItemMap) -> {
                List<Object> summedList;
                ArrayList<Object> newPoolList = new ArrayList<Object>();
                Object2FloatOpenHashMap itemsToAdd = new Object2FloatOpenHashMap();
                ArrayList itemsToRemove = new ArrayList();
                for (TextKey textKey : poolList) {
                    poolItemMap.forEach((arg_0, arg_1) -> AbstractTextKeyParsingClientLootTable.lambda$build$0(textKey, world, itemsToRemove, poolItemMap, (Object2FloatMap)itemsToAdd, arg_0, arg_1));
                    Component text = textKey.processText();
                    newPoolList.add(new Tuple((Object)textKey.index(), (Object)text));
                }
                for (TextKey textKey : list) {
                    poolItemMap.forEach((arg_0, arg_1) -> AbstractTextKeyParsingClientLootTable.lambda$build$1(textKey, world, itemsToRemove, poolItemMap, (Object2FloatMap)itemsToAdd, arg_0, arg_1));
                }
                if (applyToAllList.isEmpty()) {
                    summedList = !(!newPoolList.isEmpty() || EMILoot.config.skippedKeys.contains("emi_loot.no_conditions") && EMILoot.config.isTooltipStyle()) ? TextKey.noConditionsList.get() : newPoolList;
                } else {
                    summedList = new ArrayList(applyToAllList);
                    summedList.addAll(newPoolList);
                }
                Object2FloatMap builderPoolMap = builderItems.getOrDefault(summedList, (Object2FloatMap)poolItemMap);
                builderPoolMap.putAll((Map)itemsToAdd);
                itemsToRemove.forEach(arg_0 -> ((Object2FloatMap)builderPoolMap).removeFloat(arg_0));
                builderItems.put(summedList, builderPoolMap);
            });
        });
        ArrayList<ClientBuiltPool> finalList = new ArrayList<ClientBuiltPool>();
        builderItems.forEach((builtList, builtMap) -> {
            Float2ObjectArrayMap consolidatedMap = new Float2ObjectArrayMap();
            builtMap.forEach((arg_0, arg_1) -> AbstractTextKeyParsingClientLootTable.lambda$build$4((Float2ObjectMap)consolidatedMap, arg_0, arg_1));
            Float2ObjectArrayMap emiConsolidatedMap = new Float2ObjectArrayMap();
            consolidatedMap.forEach((arg_0, arg_1) -> AbstractTextKeyParsingClientLootTable.lambda$build$5((Float2ObjectMap)emiConsolidatedMap, arg_0, arg_1));
            finalList.add(new ClientBuiltPool((List<Tuple<Integer, Component>>)builtList, emiConsolidatedMap.float2ObjectEntrySet().stream().map(entry -> {
                List<ItemStack> sortedList = ((List)entry.getValue()).stream().sorted(Comparator.comparingInt(s -> BuiltInRegistries.ITEM.getId((Object)s.getItem()))).toList();
                return new ConditionalStack((List<Tuple<Integer, Component>>)builtList, entry.getFloatKey(), sortedList);
            }).toList()));
        });
        this.builtItems = finalList;
    }

    abstract Tuple<ResourceLocation, ResourceLocation> getBufId(FriendlyByteBuf var1);

    abstract T simpleTableToReturn(Tuple<ResourceLocation, ResourceLocation> var1, FriendlyByteBuf var2);

    abstract T emptyTableToReturn();

    abstract T filledTableToReturn(Tuple<ResourceLocation, ResourceLocation> var1, Map<List<TextKey>, ClientRawPool> var2);

    @Override
    public LootReceiver fromBuf(FriendlyByteBuf buf) {
        ResourceLocation id;
        Tuple<ResourceLocation, ResourceLocation> ids;
        boolean isEmpty = true;
        try {
            ids = this.getBufId(buf);
            id = (ResourceLocation)ids.getA();
        }
        catch (Throwable e) {
            throw new DecoderException("Parsing of Loot Receiver failed before id could be parsed", e);
        }
        try {
            int builderCount;
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.info("parsing table {}", (Object)id);
            }
            if ((builderCount = buf.readShort()) == -1) {
                return this.simpleTableToReturn(ids, buf);
            }
            LinkedHashMap<List<TextKey>, ClientRawPool> itemMap = new LinkedHashMap<List<TextKey>, ClientRawPool>();
            for (int b = 0; b < builderCount; ++b) {
                int conditionSize = buf.readShort();
                ArrayList<TextKey> qualifierList = new ArrayList<TextKey>(conditionSize + 1);
                for (int i = 0; i < conditionSize; ++i) {
                    try {
                        TextKey key = TextKey.fromBuf(buf);
                        qualifierList.add(key);
                        continue;
                    }
                    catch (DecoderException e) {
                        EMILoot.LOGGER.error("Client table {} had a TextKey decoding error while reading a loot condition!", (Object)id);
                    }
                }
                int functionSize = buf.readShort();
                for (int i = 0; i < functionSize; ++i) {
                    try {
                        TextKey key = TextKey.fromBuf(buf);
                        qualifierList.add(key);
                        continue;
                    }
                    catch (DecoderException e) {
                        EMILoot.LOGGER.error("Client table {} had a TextKey decoding error while reading a loot function!", (Object)id);
                    }
                }
                ClientRawPool pool = itemMap.getOrDefault(qualifierList, new ClientRawPool(new LinkedHashMap<List<TextKey>, Object2FloatMap<ItemStack>>()));
                int pileSize = buf.readShort();
                for (int i = 0; i < pileSize; ++i) {
                    int pileQualifierSize = buf.readShort();
                    ArrayList<TextKey> pileQualifierList = new ArrayList<TextKey>(pileQualifierSize);
                    for (int j = 0; j < pileQualifierSize; ++j) {
                        try {
                            TextKey key = TextKey.fromBuf(buf);
                            pileQualifierList.add(key);
                            continue;
                        }
                        catch (DecoderException e) {
                            EMILoot.LOGGER.error("Client table {} had a TextKey decoding error while reading an item pile qualifier!", (Object)id);
                        }
                    }
                    Object2FloatMap<ItemStack> pileItemMap = pool.map().getOrDefault(pileQualifierList, (Object2FloatMap<ItemStack>)new Object2FloatOpenHashMap());
                    int pileItemSize = buf.readShort();
                    for (int j = 0; j < pileItemSize; ++j) {
                        ItemStack stack = this.readItemStack(buf);
                        float weight = buf.readFloat();
                        pileItemMap.put((Object)stack, weight);
                        isEmpty = false;
                    }
                    pool.map().put(pileQualifierList, pileItemMap);
                }
                itemMap.put(qualifierList, pool);
            }
            if (isEmpty) {
                return this.emptyTableToReturn();
            }
            return this.filledTableToReturn(ids, itemMap);
        }
        catch (Throwable e) {
            throw new DecoderException("Parsing of Loot Receiver failed for id: " + id.toString(), e);
        }
    }

    private static /* synthetic */ void lambda$build$5(Float2ObjectMap emiConsolidatedMap, Float consolidatedWeight, List consolidatedList) {
        emiConsolidatedMap.put(consolidatedWeight.floatValue(), (Object)consolidatedList);
    }

    private static /* synthetic */ void lambda$build$4(Float2ObjectMap consolidatedMap, ItemStack stack, Float weight) {
        List consolidatedList = (List)consolidatedMap.getOrDefault(weight.floatValue(), new ArrayList());
        if (!consolidatedList.contains(stack)) {
            consolidatedList.add(stack);
        }
        consolidatedMap.put(weight.floatValue(), (Object)consolidatedList);
    }

    private static /* synthetic */ void lambda$build$1(TextKey textKey, Level world, List itemsToRemove, Object2FloatMap poolItemMap, Object2FloatMap itemsToAdd, ItemStack poolStack, Float weight) {
        List<ItemStack> stacks = textKey.processStack(poolStack, world);
        float toAddWeight = 1.0f;
        if (!stacks.contains(poolStack)) {
            itemsToRemove.add(poolStack);
            toAddWeight = weight.floatValue();
        }
        for (ItemStack stack : stacks) {
            if (!poolItemMap.containsKey((Object)stack)) continue;
            toAddWeight = poolItemMap.getFloat((Object)stack);
        }
        for (ItemStack stack : stacks) {
            if (poolItemMap.containsKey((Object)stack)) continue;
            itemsToAdd.put((Object)stack, toAddWeight);
        }
    }

    private static /* synthetic */ void lambda$build$0(TextKey textKey, Level world, List itemsToRemove, Object2FloatMap poolItemMap, Object2FloatMap itemsToAdd, ItemStack poolStack, Float weight) {
        List<ItemStack> stacks = textKey.processStack(poolStack, world);
        float toAddWeight = 1.0f;
        if (!stacks.contains(poolStack)) {
            itemsToRemove.add(poolStack);
            toAddWeight = weight.floatValue();
        }
        for (ItemStack stack : stacks) {
            if (!poolItemMap.containsKey((Object)stack)) continue;
            toAddWeight = poolItemMap.getFloat((Object)stack);
        }
        for (ItemStack stack : stacks) {
            if (poolItemMap.containsKey((Object)stack)) continue;
            itemsToAdd.put((Object)stack, toAddWeight);
        }
    }
}

