/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.endrem.block;

import com.teamremastered.endrem.EndRemasteredCommon;
import com.teamremastered.endrem.registry.CommonBlockRegistry;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class AncientPortalFrameEntity
extends BlockEntity {
    private String eye = "empty";
    public Material eyeTexture;

    public AncientPortalFrameEntity(BlockPos pos, BlockState state) {
        super(CommonBlockRegistry.ANCIENT_PORTAL_FRAME_ENTITY, pos, state);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.saveAdditional(nbt, provider);
        nbt.putString("eye_inside", this.eye);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.eye = nbt.getString("eye_inside");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        this.saveAdditional(nbt, registries);
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void setEye(String eye) {
        this.eye = eye;
    }

    public String getEye() {
        return this.eye;
    }

    public ResourceLocation getEyeID() {
        return EndRemasteredCommon.ModResourceLocation(this.eye);
    }

    public Item getEyeItem() {
        return (Item)BuiltInRegistries.ITEM.get(this.getEyeID());
    }

    public boolean isEmpty() {
        return this.eye.equals("empty");
    }
}

