/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder;

import com.google.common.collect.Lists;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderRegistry;
import de.keksuccino.fancymenu.customization.variables.Variable;
import de.keksuccino.fancymenu.customization.variables.VariableHandler;
import de.keksuccino.fancymenu.util.rendering.text.TextFormattingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorScreen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.resources.language.I18n;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderParser {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final HashMap<String, Long> LOG_COOLDOWN = new HashMap();
    private static final long LOG_COOLDOWN_MS = 10000L;
    private static final HashSet<String> TOO_LONG_TO_PARSE = new HashSet();
    private static final HashMap<String, Boolean> CONTAINS_PLACEHOLDERS = new HashMap();
    private static final HashMap<String, Pair<String, Long>> PLACEHOLDER_CACHE = new HashMap();
    private static final int MAX_TEXT_LENGTH = 17000;
    private static final String PLACEHOLDER_PREFIX = "{\"placeholder\":\"";
    private static final String EMPTY_STRING = "";
    private static final char OPEN_CURLY_BRACKETS_CHAR = '{';
    private static final char CLOSE_CURLY_BRACKETS_CHAR = '}';
    private static final String FORMATTING_PREFIX_AND = "&";
    private static final String FORMATTING_PREFIX_PARAGRAPH = "\u00a7";
    private static final String SHORT_VARIABLE_PLACEHOLDER_PREFIX = "$$";
    private static final char DOLLAR_CHAR = '$';
    private static final String APOSTROPHE = "\"";
    private static final char APOSTROPHE_CHAR = '\"';
    private static final char NEWLINE_CHAR = '\n';
    private static final char BACKSLASH_CHAR = '\\';
    private static final char SPACE_CHAR = ' ';
    private static final char TAB_CHAR = '\t';
    private static final char CARRIAGE_RETURN_CHAR = '\r';
    private static final char COLON_CHAR = ':';
    private static final char COMMA_CHAR = ',';
    private static final char PERCENT_CHAR = '%';
    private static final char LOWERCASE_N_CHAR = 'n';
    private static final String BACKSLASH = "\\";
    private static final String COMMA = ",";
    private static final String COMMA_WRAPPED_IN_APOSTROPHES = "\",\"";
    private static final String COLON_WRAPPED_IN_APOSTROPHES = "\":\"";
    private static final String PERCENT_NEWLINE_CODE = "%n%";
    private static final String TOO_LONG_TO_PARSE_LOCALIZATION = "fancymenu.placeholders.error.text_too_long";

    public static boolean isCachingPlaceholders() {
        return FancyMenu.getOptions().placeholderCachingDurationMs.getValue() > 0L;
    }

    public static long getPlaceholderCachingDurationMs() {
        return FancyMenu.getOptions().placeholderCachingDurationMs.getValue();
    }

    public static boolean containsPlaceholders(@Nullable String in, boolean checkForVariableReferences, boolean checkForFormattingCodes) {
        if (in == null) {
            return false;
        }
        if (in.length() <= 2) {
            return false;
        }
        if (StringUtils.contains((CharSequence)in, (CharSequence)"{\"placeholder\"")) {
            return true;
        }
        if (checkForFormattingCodes && in.hashCode() != TextFormattingUtils.replaceFormattingCodes(in, FORMATTING_PREFIX_AND, FORMATTING_PREFIX_PARAGRAPH).hashCode()) {
            return true;
        }
        return checkForVariableReferences && in.hashCode() != PlaceholderParser.replaceVariableReferences(in).hashCode();
    }

    public static boolean containsPlaceholders(@Nullable String in, boolean checkForVariableReferences) {
        return PlaceholderParser.containsPlaceholders(in, checkForVariableReferences, true);
    }

    @NotNull
    public static String replacePlaceholders(@Nullable String in) {
        return PlaceholderParser.replacePlaceholders(in, true);
    }

    @NotNull
    public static String replacePlaceholders(@Nullable String in, boolean replaceFormattingCodes) {
        return PlaceholderParser.replacePlaceholders(in, null, replaceFormattingCodes);
    }

    @NotNull
    protected static String replacePlaceholders(@Nullable String in, @Nullable HashMap<String, String> parsed, boolean replaceFormattingCodes) {
        Pair<String, Long> cached;
        if (in == null) {
            return EMPTY_STRING;
        }
        if ((in = TextEditorScreen.compileSingleLineString(in)).length() <= 2) {
            return in;
        }
        Boolean containsPlaceholders = CONTAINS_PLACEHOLDERS.get(in);
        if (containsPlaceholders == null) {
            containsPlaceholders = PlaceholderParser.containsPlaceholders(in, true, replaceFormattingCodes);
            CONTAINS_PLACEHOLDERS.put(in, containsPlaceholders);
        }
        if (!containsPlaceholders.booleanValue()) {
            return in;
        }
        if (TOO_LONG_TO_PARSE.contains(in)) {
            return I18n.get((String)TOO_LONG_TO_PARSE_LOCALIZATION, (Object[])new Object[0]);
        }
        if (in.length() >= 17000) {
            TOO_LONG_TO_PARSE.add(in);
            return I18n.get((String)TOO_LONG_TO_PARSE_LOCALIZATION, (Object[])new Object[0]);
        }
        if (PlaceholderParser.isCachingPlaceholders() && (cached = PLACEHOLDER_CACHE.get(in)) != null && (Long)cached.getValue() + PlaceholderParser.getPlaceholderCachingDurationMs() > System.currentTimeMillis()) {
            return (String)cached.getKey();
        }
        String original = in;
        if (parsed == null) {
            parsed = new HashMap();
        }
        int hash = in.hashCode();
        while (true) {
            for (ParsedPlaceholder p : Lists.reverse(PlaceholderParser.findPlaceholders(in, parsed, replaceFormattingCodes))) {
                String replacement = parsed.get(p.placeholderString);
                if (replacement == null) {
                    replacement = p.getReplacement();
                    parsed.put(p.placeholderString, replacement);
                }
                in = StringUtils.replace((String)in, (String)p.placeholderString, (String)replacement);
            }
            int hashNew = in.hashCode();
            if (hashNew == hash) break;
            hash = hashNew;
        }
        if (replaceFormattingCodes) {
            in = TextFormattingUtils.replaceFormattingCodes(in, FORMATTING_PREFIX_AND, FORMATTING_PREFIX_PARAGRAPH);
        }
        in = PlaceholderParser.replaceVariableReferences(in);
        if (PlaceholderParser.isCachingPlaceholders()) {
            PLACEHOLDER_CACHE.put(original, (Pair<String, Long>)Pair.of((Object)in, (Object)System.currentTimeMillis()));
        }
        return in;
    }

    @NotNull
    public static List<ParsedPlaceholder> findPlaceholders(@Nullable String in, @NotNull HashMap<String, String> parsed, boolean replaceFormattingCodes) {
        ArrayList<ParsedPlaceholder> placeholders = new ArrayList<ParsedPlaceholder>();
        if (in == null) {
            return placeholders;
        }
        for (int i = 0; i < in.length(); ++i) {
            String candidate;
            String normalized;
            String sub;
            int endIndex;
            if (in.charAt(i) != '{' || (endIndex = PlaceholderParser.findPlaceholderEndIndex(sub = StringUtils.substring((String)in, (int)i), i)) == -1 || !(normalized = PlaceholderParser.normalizePlaceholderString(candidate = StringUtils.substring((String)in, (int)i, (int)(endIndex + 1)))).startsWith(PLACEHOLDER_PREFIX)) continue;
            placeholders.add(new ParsedPlaceholder(candidate, i, endIndex + 1, parsed, replaceFormattingCodes));
            i = endIndex;
        }
        return placeholders;
    }

    private static int findPlaceholderEndIndex(@NotNull String placeholderStartSubString, int startIndex) {
        int currentIndex = startIndex;
        int depth = 0;
        boolean backslash = false;
        for (char c : placeholderStartSubString.toCharArray()) {
            if (currentIndex != startIndex) {
                if (c == '{' && !backslash) {
                    ++depth;
                } else if (c == '}' && !backslash) {
                    if (depth <= 0) {
                        return currentIndex;
                    }
                    --depth;
                }
                backslash = c == '\\';
            }
            ++currentIndex;
        }
        return -1;
    }

    @NotNull
    private static String normalizePlaceholderString(@NotNull String placeholderString) {
        StringBuilder result = new StringBuilder(placeholderString.length());
        boolean inQuotes = false;
        boolean isEscaped = false;
        for (int i = 0; i < placeholderString.length(); ++i) {
            char c = placeholderString.charAt(i);
            if (!isEscaped && i + 2 < placeholderString.length() && c == '%' && placeholderString.charAt(i + 1) == 'n' && placeholderString.charAt(i + 2) == '%') {
                if (inQuotes) {
                    result.append(PERCENT_NEWLINE_CODE);
                }
                i += 2;
                continue;
            }
            if (isEscaped) {
                result.append('\\');
                result.append(c);
                isEscaped = false;
                continue;
            }
            if (c == '\\') {
                isEscaped = true;
                continue;
            }
            if (c == '\"') {
                inQuotes = !inQuotes;
                result.append(c);
                continue;
            }
            if (inQuotes) {
                result.append(c);
                continue;
            }
            if (PlaceholderParser.isWhitespace(c)) continue;
            result.append(c);
        }
        return result.toString();
    }

    private static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    @NotNull
    public static String replaceVariableReferences(@NotNull String in) {
        String replaced = in;
        int index = 0;
        for (char c : in.toCharArray()) {
            String sub;
            if (c == '$' && StringUtils.startsWith((CharSequence)(sub = StringUtils.substring((String)in, (int)index)), (CharSequence)SHORT_VARIABLE_PLACEHOLDER_PREFIX)) {
                for (Variable variable : VariableHandler.getVariables()) {
                    if (!StringUtils.startsWith((CharSequence)sub, (CharSequence)(SHORT_VARIABLE_PLACEHOLDER_PREFIX + variable.getName()))) continue;
                    replaced = StringUtils.replace((String)replaced, (String)(SHORT_VARIABLE_PLACEHOLDER_PREFIX + variable.getName()), (String)variable.getValue());
                    break;
                }
            }
            ++index;
        }
        return replaced;
    }

    private static void logError(@NotNull String error, @Nullable Exception ex) {
        long now = System.currentTimeMillis();
        Long last = LOG_COOLDOWN.get(error);
        if (last != null && last + 10000L < now) {
            last = null;
            LOG_COOLDOWN.remove(error);
        }
        if (last == null) {
            if (ex != null) {
                LOGGER.error(error, (Throwable)ex);
            } else {
                LOGGER.error(error);
            }
            LOG_COOLDOWN.put(error, now);
        }
    }

    public static class ParsedPlaceholder {
        public final String placeholderString;
        public final int startIndex;
        public final int endIndex;
        private final HashMap<String, String> parsed;
        private final boolean replaceFormattingCodes;
        private Integer hashcode;
        private String identifier;
        private boolean identifierFailed = false;
        private Placeholder placeholder;
        private boolean placeholderFailed = false;
        private String normalizedString;

        protected ParsedPlaceholder(@NotNull String placeholderString, int startIndex, int endIndex, @NotNull HashMap<String, String> parsed, boolean replaceFormattingCodes) {
            this.placeholderString = placeholderString;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.parsed = parsed;
            this.replaceFormattingCodes = replaceFormattingCodes;
        }

        @NotNull
        private String getNormalizedString() {
            if (this.normalizedString == null) {
                this.normalizedString = PlaceholderParser.normalizePlaceholderString(this.placeholderString);
            }
            return this.normalizedString;
        }

        @Nullable
        public String getIdentifier() {
            if (this.identifierFailed) {
                return null;
            }
            if (this.identifier != null) {
                return this.identifier;
            }
            try {
                String normalized = this.getNormalizedString();
                String afterPrefix = StringUtils.substring((String)normalized, (int)PlaceholderParser.PLACEHOLDER_PREFIX.length());
                int endQuoteIndex = afterPrefix.indexOf(34);
                if (endQuoteIndex > 0) {
                    this.identifier = afterPrefix.substring(0, endQuoteIndex);
                    return this.identifier;
                }
            }
            catch (Exception ex) {
                PlaceholderParser.logError("[FANCYMENU] Failed to parse identifier of placeholder: " + this.placeholderString, ex);
                this.identifierFailed = true;
            }
            return null;
        }

        @NotNull
        public String getReplacement() {
            String identifier = this.getIdentifier();
            if (identifier == null) {
                return this.placeholderString;
            }
            Placeholder p = this.getPlaceholder();
            if (p == null) {
                return this.placeholderString;
            }
            HashMap<String, String> values = this.getValues();
            if (this.hasValues() && (values == null || values.isEmpty())) {
                return this.placeholderString;
            }
            DeserializedPlaceholderString deserialized = new DeserializedPlaceholderString(identifier, null, this.placeholderString);
            if (values != null) {
                for (Map.Entry<String, String> value : values.entrySet()) {
                    deserialized.values.put(value.getKey(), PlaceholderParser.replacePlaceholders(value.getValue(), this.parsed, this.replaceFormattingCodes));
                }
            }
            return p.getReplacementFor(deserialized);
        }

        @Nullable
        public HashMap<String, String> getValues() {
            HashMap<String, String> values = new HashMap<String, String>();
            try {
                Placeholder placeholder = this.getPlaceholder();
                if (placeholder == null || !this.hasValues()) {
                    return null;
                }
                String normalized = this.getNormalizedString();
                if (!normalized.contains(PlaceholderParser.COMMA)) {
                    return null;
                }
                String[] parts = StringUtils.split((String)normalized, (String)PlaceholderParser.COMMA, (int)2);
                if (parts.length < 2) {
                    return null;
                }
                String valueString = PlaceholderParser.COMMA + parts[1];
                int currentIndex = 0;
                int inValueDepth = 0;
                String currentValueName = null;
                int currentValueStartIndex = 0;
                for (char c : valueString.toCharArray()) {
                    if (currentIndex >= currentValueStartIndex) {
                        if (c == '\"') {
                            if (currentValueName != null) {
                                if (inValueDepth == 0 && !StringUtils.startsWith((CharSequence)StringUtils.substring((String)valueString, (int)(currentIndex - 1)), (CharSequence)PlaceholderParser.BACKSLASH) && ParsedPlaceholder.isEndOfValueContent(placeholder, valueString, currentIndex)) {
                                    String valueContent = StringUtils.substring((String)valueString, (int)currentValueStartIndex, (int)currentIndex);
                                    values.put(currentValueName, valueContent);
                                    currentValueName = null;
                                    currentValueStartIndex = 0;
                                }
                            } else {
                                currentValueName = ParsedPlaceholder.getValueNameIfStartingWithValue(placeholder, StringUtils.substring((String)valueString, (int)currentIndex));
                                if (currentValueName != null) {
                                    currentValueStartIndex = currentIndex + currentValueName.length() + 4;
                                    inValueDepth = 0;
                                }
                            }
                        }
                        if (c == '{' && currentValueName != null && !StringUtils.startsWith((CharSequence)StringUtils.substring((String)valueString, (int)(currentIndex - 1)), (CharSequence)PlaceholderParser.BACKSLASH)) {
                            ++inValueDepth;
                        }
                        if (c == '}' && currentValueName != null && !StringUtils.startsWith((CharSequence)StringUtils.substring((String)valueString, (int)(currentIndex - 1)), (CharSequence)PlaceholderParser.BACKSLASH) && inValueDepth > 0) {
                            --inValueDepth;
                        }
                    }
                    ++currentIndex;
                }
                return values;
            }
            catch (Exception ex) {
                PlaceholderParser.logError("[FANCYMENU] Failed to parse values of placeholder: " + this.placeholderString, ex);
                return null;
            }
        }

        private static boolean isEndOfValueContent(@NotNull Placeholder placeholder, @NotNull String valueString, int currentIndex) {
            if (valueString.length() == currentIndex + 3) {
                return true;
            }
            if (StringUtils.startsWith((CharSequence)StringUtils.substring((String)valueString, (int)currentIndex), (CharSequence)PlaceholderParser.COMMA_WRAPPED_IN_APOSTROPHES)) {
                String nextValue = ParsedPlaceholder.getValueNameIfStartingWithValue(placeholder, StringUtils.substring((String)valueString, (int)(currentIndex + 2)));
                return nextValue != null;
            }
            return false;
        }

        @Nullable
        private static String getValueNameIfStartingWithValue(@NotNull Placeholder placeholder, @NotNull String s) {
            if (placeholder.getValueNames() == null || placeholder.getValueNames().isEmpty()) {
                return null;
            }
            for (String name : placeholder.getValueNames()) {
                if (!StringUtils.startsWith((CharSequence)s, (CharSequence)(PlaceholderParser.APOSTROPHE + name + PlaceholderParser.COLON_WRAPPED_IN_APOSTROPHES))) continue;
                return name;
            }
            return null;
        }

        public boolean hasValues() {
            Placeholder p = this.getPlaceholder();
            if (p == null) {
                return false;
            }
            return p.getValueNames() != null && !p.getValueNames().isEmpty();
        }

        @Nullable
        public Placeholder getPlaceholder() {
            if (this.placeholderFailed) {
                return null;
            }
            if (this.placeholder == null) {
                this.placeholder = PlaceholderRegistry.getPlaceholder(this.getIdentifier());
            }
            this.placeholderFailed = this.placeholder == null;
            return this.placeholder;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ParsedPlaceholder) {
                ParsedPlaceholder p = (ParsedPlaceholder)obj;
                return this.placeholderString.equals(p.placeholderString) && this.startIndex == p.startIndex && this.endIndex == p.endIndex;
            }
            return false;
        }

        public int hashCode() {
            if (this.hashcode == null) {
                this.hashcode = Objects.hash(this.placeholderString, this.startIndex, this.endIndex);
            }
            return this.hashcode;
        }
    }
}

