/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.scoreboard;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Scoreboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScoreboardObjectiveCriteriaPlaceholder
extends Placeholder {
    public ScoreboardObjectiveCriteriaPlaceholder() {
        super("scoreboard_objective_criteria");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        Scoreboard scoreboard;
        Objective objective;
        ClientLevel level = Minecraft.getInstance().level;
        String objectiveName = dps.values.get("objective");
        if (level != null && objectiveName != null && (objective = (scoreboard = level.getScoreboard()).getObjective(objectiveName)) != null) {
            return objective.getCriteria().getName();
        }
        return "";
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        return List.of("objective");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.get((String)"fancymenu.placeholders.scoreboard.objective_criteria", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.scoreboard.objective_criteria.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.get((String)"fancymenu.placeholders.categories.scoreboard", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("objective", "score");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}

