/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.mcef;

import de.keksuccino.fancymenu.util.mcef.WrappedMCEFBrowser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowserLoadEventListenerManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final BrowserLoadEventListenerManager INSTANCE = new BrowserLoadEventListenerManager();
    private final Map<String, List<BrowserLoadListener>> browserMap = new ConcurrentHashMap<String, List<BrowserLoadListener>>();
    private final CefLoadHandlerAdapter globalHandler = new CefLoadHandlerAdapter(){

        public void onLoadEnd(CefBrowser cefBrowser, CefFrame frame, int httpStatusCode) {
            if (!frame.isMain()) {
                return;
            }
            String browserId = BrowserLoadEventListenerManager.this.getIdByCefBrowser(cefBrowser);
            if (browserId == null) {
                return;
            }
            List<BrowserLoadListener> loadListeners = BrowserLoadEventListenerManager.this.browserMap.get(browserId);
            if (loadListeners != null) {
                boolean success = httpStatusCode >= 200 && httpStatusCode < 300 || frame.getURL() != null && frame.getURL().startsWith("file:") && httpStatusCode == 0;
                loadListeners.forEach(loadListener -> {
                    if (!loadListener.isHandled()) {
                        loadListener.setHandled(true);
                        loadListener.getOnLoadCompletedTask().accept(success);
                    }
                });
                loadListeners.clear();
            } else {
                LOGGER.warn("[FANCYMENU] onLoadEnd: No load listeners found for browser ID: {}", (Object)browserId);
            }
        }

        public void onLoadError(CefBrowser cefBrowser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
            if (!frame.isMain()) {
                return;
            }
            String browserId = BrowserLoadEventListenerManager.this.getIdByCefBrowser(cefBrowser);
            if (browserId == null) {
                return;
            }
            List<BrowserLoadListener> loadListeners = BrowserLoadEventListenerManager.this.browserMap.get(browserId);
            if (loadListeners != null) {
                loadListeners.forEach(loadListener -> {
                    if (!loadListener.isHandled()) {
                        LOGGER.error("[FANCYMENU] Browser [ID:{}] load error: {}, {}, URL: {}", (Object)browserId, (Object)errorCode, (Object)errorText, (Object)failedUrl);
                        loadListener.setHandled(true);
                        loadListener.getOnLoadCompletedTask().accept(false);
                    }
                });
                loadListeners.clear();
            } else {
                LOGGER.warn("[FANCYMENU] onLoadError: No load listeners found for browser ID: {}", (Object)browserId);
            }
        }
    };

    private BrowserLoadEventListenerManager() {
    }

    public static BrowserLoadEventListenerManager getInstance() {
        return INSTANCE;
    }

    public CefLoadHandler getGlobalHandler() {
        return this.globalHandler;
    }

    public void registerListenerForBrowser(@NotNull WrappedMCEFBrowser browser, @NotNull Consumer<Boolean> onLoadListener) {
        if (!this.browserMap.containsKey(browser.getIdentifier())) {
            this.browserMap.put(browser.getIdentifier(), new ArrayList());
        }
        this.browserMap.get(browser.getIdentifier()).add(new BrowserLoadListener(browser, onLoadListener));
    }

    public void unregisterAllListenersForBrowser(String browserId) {
        this.browserMap.remove(browserId);
    }

    @Nullable
    public String getIdByCefBrowser(@NotNull CefBrowser cefBrowser) {
        for (Map.Entry<String, List<BrowserLoadListener>> m : this.browserMap.entrySet()) {
            BrowserLoadListener listener1;
            if (m.getValue().isEmpty() || !Objects.equals((listener1 = m.getValue().get(0)).getBrowser().getBrowser(), cefBrowser)) continue;
            return m.getKey();
        }
        return null;
    }

    private static class BrowserLoadListener {
        private final Consumer<Boolean> onLoadCompleted;
        private final WrappedMCEFBrowser browser;
        private volatile boolean handled = false;

        public BrowserLoadListener(WrappedMCEFBrowser browser, Consumer<Boolean> onLoadCompleted) {
            this.onLoadCompleted = onLoadCompleted;
            this.browser = browser;
        }

        public Consumer<Boolean> getOnLoadCompletedTask() {
            return this.onLoadCompleted;
        }

        public WrappedMCEFBrowser getBrowser() {
            return this.browser;
        }

        public boolean isHandled() {
            return this.handled;
        }

        public void setHandled(boolean handled) {
            this.handled = handled;
        }
    }
}

