/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor;

import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorLine;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorScreen;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class TextEditorHistory {
    private static final Logger LOGGER = LogManager.getLogger();
    protected TextEditorScreen parent;
    protected List<Snapshot> snapshots = new ArrayList<Snapshot>();
    protected int index = 0;

    protected TextEditorHistory(@NotNull TextEditorScreen parent) {
        this.parent = parent;
    }

    public void saveSnapshot() {
        try {
            TextEditorLine focusedLine;
            if (this.index > 0 && this.snapshots.get((int)(this.index - 1)).text.equals(this.parent.getText())) {
                return;
            }
            if (this.index < this.snapshots.size()) {
                if (this.index == 0) {
                    this.snapshots.clear();
                } else {
                    this.snapshots = this.snapshots.subList(0, this.index);
                }
            }
            int cursorPos = (focusedLine = this.parent.getFocusedLine()) != null ? focusedLine.getCursorPosition() : 0;
            this.snapshots.add(new Snapshot(this.parent.getText(), this.parent.getFocusedLineIndex(), cursorPos, this.parent.verticalScrollBar.getScroll(), this.parent.horizontalScrollBar.getScroll()));
            this.index = this.snapshots.size();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void stepBack() {
        try {
            if (this.snapshots.isEmpty()) {
                return;
            }
            if (this.index > 0) {
                if (this.index == this.snapshots.size()) {
                    if (!this.snapshots.get((int)(this.index - 1)).text.equals(this.parent.getText())) {
                        this.saveSnapshot();
                        --this.index;
                    } else if (this.index > 1) {
                        --this.index;
                    }
                }
                --this.index;
                this.restoreFrom(this.snapshots.get(this.index));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void stepForward() {
        try {
            if (this.snapshots.isEmpty()) {
                return;
            }
            ++this.index;
            if (this.index >= this.snapshots.size()) {
                this.index = this.snapshots.size() - 1;
            }
            this.restoreFrom(this.snapshots.get(this.index));
            if (this.index == this.snapshots.size() - 1) {
                this.index = this.snapshots.size();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void restoreFrom(@NotNull Snapshot snap) {
        this.parent.setText(snap.text);
        if (snap.focusedLineIndex != -1) {
            this.parent.setFocusedLine(snap.focusedLineIndex);
            TextEditorLine focused = this.parent.getFocusedLine();
            if (focused != null) {
                focused.setCursorPosition(snap.cursorPos);
                focused.setHighlightPos(snap.cursorPos);
            }
        }
        this.parent.verticalScrollBar.setScroll(snap.verticalScroll, false);
        this.parent.horizontalScrollBar.setScroll(snap.horizontalScroll, false);
    }

    public record Snapshot(@NotNull String text, int focusedLineIndex, int cursorPos, float verticalScroll, float horizontalScroll) {
    }
}

