/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.FTBLibraryCommands;
import dev.ftb.mods.ftblibrary.net.EditNBTPacket;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbteams.FTBTeamsAPIImpl;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamManager;
import dev.ftb.mods.ftbteams.api.TeamRank;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import dev.ftb.mods.ftbteams.api.event.TeamInfoEvent;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyArgument;
import dev.ftb.mods.ftbteams.data.AbstractTeam;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.ServerTeam;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamArgumentProvider;
import dev.ftb.mods.ftbteams.data.TeamManagerImpl;
import dev.ftb.mods.ftbteams.data.TeamType;
import java.util.Collection;
import java.util.Comparator;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;

public class FTBTeamsCommands {
    public void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ftbteams").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"party").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"create").requires(this::hasNoParty)).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> FTBTeamsCommands.tryCreateParty((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"))))).executes(ctx -> FTBTeamsCommands.tryCreateParty((CommandSourceStack)ctx.getSource(), "")))).then(((LiteralArgumentBuilder)Commands.literal((String)"join").requires(this::hasNoParty)).then(FTBTeamsCommands.createTeamArg(TeamType.PARTY).executes(ctx -> FTBTeamsCommands.partyTeamArg((CommandContext<CommandSourceStack>)ctx, TeamRank.INVITED).join(((CommandSourceStack)ctx.getSource()).getPlayerOrException()))))).then(((LiteralArgumentBuilder)Commands.literal((String)"decline").requires(this::hasNoParty)).then(FTBTeamsCommands.createTeamArg(TeamType.PARTY).executes(ctx -> FTBTeamsCommands.partyTeamArg((CommandContext<CommandSourceStack>)ctx, TeamRank.INVITED).declineInvitation((CommandSourceStack)ctx.getSource()))))).then(((LiteralArgumentBuilder)Commands.literal((String)"leave").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.MEMBER))).executes(ctx -> FTBTeamsCommands.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.MEMBER).leave(((CommandSourceStack)ctx.getSource()).getPlayerOrException().getUUID())))).then(((LiteralArgumentBuilder)Commands.literal((String)"invite").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.OFFICER))).then(Commands.argument((String)"players", (ArgumentType)GameProfileArgument.gameProfile()).executes(ctx -> FTBTeamsCommands.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.OFFICER).invite(((CommandSourceStack)ctx.getSource()).getPlayerOrException(), GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"players")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"kick").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.OFFICER))).then(Commands.argument((String)"players", (ArgumentType)GameProfileArgument.gameProfile()).executes(ctx -> FTBTeamsCommands.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.OFFICER).kick((CommandSourceStack)ctx.getSource(), GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"players")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"transfer_ownership").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.OWNER))).then(Commands.argument((String)"player_id", (ArgumentType)GameProfileArgument.gameProfile()).executes(ctx -> FTBTeamsCommands.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.OWNER).transferOwnership((CommandSourceStack)ctx.getSource(), GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"player_id")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"transfer_ownership_for").requires(FTBTeamsCommands.requiresOPorSP())).then(FTBTeamsCommands.createTeamArg(TeamType.PARTY).then(Commands.argument((String)"player_id", (ArgumentType)GameProfileArgument.gameProfile()).executes(ctx -> FTBTeamsCommands.partyTeamArg((CommandContext<CommandSourceStack>)ctx, TeamRank.NONE).transferOwnership((CommandSourceStack)ctx.getSource(), GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"player_id"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"settings").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.OWNER))).then(((RequiredArgumentBuilder)Commands.argument((String)"key", (ArgumentType)TeamPropertyArgument.create()).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> FTBTeamsCommands.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.OWNER).settings((CommandSourceStack)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSourceStack>)ctx, "key"), FTBTeamsCommands.string(ctx, "value"))))).executes(ctx -> FTBTeamsCommands.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.OWNER).settings((CommandSourceStack)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSourceStack>)ctx, "key"), ""))))).then(((LiteralArgumentBuilder)Commands.literal((String)"settings_for").requires(FTBTeamsCommands.requiresOPorSP())).then(FTBTeamsCommands.createTeamArg(TeamType.PARTY).then(((RequiredArgumentBuilder)Commands.argument((String)"key", (ArgumentType)TeamPropertyArgument.create()).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> FTBTeamsCommands.partyTeamArg((CommandContext<CommandSourceStack>)ctx, TeamRank.NONE).settings((CommandSourceStack)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSourceStack>)ctx, "key"), FTBTeamsCommands.string(ctx, "value"))))).executes(ctx -> FTBTeamsCommands.partyTeamArg((CommandContext<CommandSourceStack>)ctx, TeamRank.NONE).settings((CommandSourceStack)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSourceStack>)ctx, "key"), "")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"allies").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.MEMBER))).then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.OFFICER))).then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).executes(ctx -> FTBTeamsCommands.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.OFFICER).addAlly((CommandSourceStack)ctx.getSource(), GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.OFFICER))).then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).executes(ctx -> FTBTeamsCommands.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.OFFICER).removeAlly((CommandSourceStack)ctx.getSource(), GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"list").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.MEMBER))).executes(ctx -> FTBTeamsCommands.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.MEMBER).listAllies((CommandSourceStack)ctx.getSource())))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"server").requires(FTBTeamsCommands.requiresOPorSP())).then(Commands.literal((String)"create").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> (Integer)TeamManagerImpl.INSTANCE.createServer((CommandSourceStack)ctx.getSource(), FTBTeamsCommands.string(ctx, "name")).getLeft())))).then(Commands.literal((String)"delete").then(FTBTeamsCommands.createTeamArg(TeamType.SERVER).executes(ctx -> FTBTeamsCommands.serverTeamArg((CommandContext<CommandSourceStack>)ctx).delete((CommandSourceStack)ctx.getSource()))))).then(Commands.literal((String)"settings").then(FTBTeamsCommands.createTeamArg(TeamType.SERVER).then(((RequiredArgumentBuilder)Commands.argument((String)"key", (ArgumentType)TeamPropertyArgument.create()).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> FTBTeamsCommands.serverTeamArg((CommandContext<CommandSourceStack>)ctx).settings((CommandSourceStack)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSourceStack>)ctx, "key"), FTBTeamsCommands.string(ctx, "value"))))).executes(ctx -> FTBTeamsCommands.serverTeamArg((CommandContext<CommandSourceStack>)ctx).settings((CommandSourceStack)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSourceStack>)ctx, "key"), ""))))))).then(Commands.literal((String)"msg").then(Commands.argument((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            FTBTeamsCommands.getTeam((CommandContext<CommandSourceStack>)ctx).sendMessage(((CommandSourceStack)ctx.getSource()).getPlayerOrException().getUUID(), StringArgumentType.getString((CommandContext)ctx, (String)"text"));
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"info").then(Commands.literal((String)"server_id").executes(ctx -> FTBTeamsCommands.serverId((CommandSourceStack)ctx.getSource())))).then(FTBTeamsCommands.createTeamArg().executes(ctx -> FTBTeamsCommands.info((CommandSourceStack)ctx.getSource(), FTBTeamsCommands.teamArg((CommandContext<CommandSourceStack>)ctx))))).executes(ctx -> FTBTeamsCommands.info((CommandSourceStack)ctx.getSource(), FTBTeamsCommands.getTeam((CommandContext<CommandSourceStack>)ctx))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"list").executes(ctx -> this.list((CommandSourceStack)ctx.getSource(), t -> true))).then(Commands.literal((String)"parties").executes(ctx -> this.list((CommandSourceStack)ctx.getSource(), Team::isPartyTeam)))).then(Commands.literal((String)"server_teams").executes(ctx -> this.list((CommandSourceStack)ctx.getSource(), Team::isServerTeam)))).then(Commands.literal((String)"players").executes(ctx -> this.list((CommandSourceStack)ctx.getSource(), Team::isPlayerTeam))))).then(((LiteralArgumentBuilder)Commands.literal((String)"force-disband").requires(source -> source.hasPermission(2))).then(FTBTeamsCommands.createTeamArg(TeamType.PARTY).executes(ctx -> FTBTeamsCommands.partyTeamArg((CommandContext<CommandSourceStack>)ctx, TeamRank.NONE).forceDisband((CommandSourceStack)ctx.getSource()))))).then(Commands.literal((String)"redirect_chat").executes(FTBTeamsCommands::redirectChatToggle))).then(((LiteralArgumentBuilder)Commands.literal((String)"force-add").requires(FTBTeamsCommands.requiresOPorSP())).then(FTBTeamsCommands.createTeamArg(TeamType.PARTY).then(Commands.argument((String)"players", (ArgumentType)GameProfileArgument.gameProfile()).executes(FTBTeamsCommands::forceAddPlayers))))).then(((LiteralArgumentBuilder)Commands.literal((String)"force-remove").requires(FTBTeamsCommands.requiresOPorSP())).then(FTBTeamsCommands.createTeamArg(TeamType.PARTY).then(Commands.argument((String)"players", (ArgumentType)GameProfileArgument.gameProfile()).executes(FTBTeamsCommands::forceRemovePlayers))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nbtedit").requires(FTBTeamsCommands.requiresOPorSP())).executes(this::editPlayerTeamNBT)).then(FTBTeamsCommands.createTeamArg().executes(FTBTeamsCommands::editTeamNBT))));
        if (Platform.isDevelopmentEnvironment()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ftbteams_add_fake_player").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"profile", (ArgumentType)GameProfileArgument.gameProfile()).executes(ctx -> this.addFakePlayer(GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"profile")))));
        }
    }

    private static Predicate<CommandSourceStack> requiresOPorSP() {
        return source -> source.getServer().isSingleplayer() || source.hasPermission(2);
    }

    private static RequiredArgumentBuilder<CommandSourceStack, TeamArgumentProvider> createTeamArg() {
        return FTBTeamsCommands.createTeamArg(null);
    }

    private static RequiredArgumentBuilder<CommandSourceStack, TeamArgumentProvider> createTeamArg(TeamType type) {
        return Commands.argument((String)"team", (ArgumentType)TeamArgument.create(type));
    }

    private static String string(CommandContext<?> context, String name) {
        return StringArgumentType.getString(context, (String)name);
    }

    private boolean hasNoParty(CommandSourceStack source) {
        if (source.getEntity() instanceof ServerPlayer) {
            return FTBTeamsAPI.api().getManager().getTeamForPlayerID(source.getEntity().getUUID()).map(team -> !team.isPartyTeam()).orElse(false);
        }
        return false;
    }

    private boolean hasParty(CommandSourceStack source, TeamRank rank) {
        if (source.getEntity() instanceof ServerPlayer) {
            UUID playerId = source.getEntity().getUUID();
            return FTBTeamsAPI.api().getManager().getTeamForPlayerID(playerId).map(team -> team.isPartyTeam() && team.getRankForPlayer(playerId).isAtLeast(rank)).orElse(false);
        }
        return false;
    }

    private static Team getTeam(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        return FTBTeamsAPI.api().getManager().getTeamForPlayer(player).orElseThrow(() -> TeamArgument.TEAM_NOT_FOUND.create((Object)player.getUUID()));
    }

    private static PartyTeam getPartyTeam(CommandContext<CommandSourceStack> context, TeamRank minRank) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Team team = FTBTeamsAPI.api().getManager().getTeamForPlayer(player).orElseThrow(() -> TeamArgument.TEAM_NOT_FOUND.create((Object)player.getUUID()));
        if (!(team instanceof PartyTeam)) {
            throw TeamArgument.NOT_IN_PARTY.create();
        }
        PartyTeam partyTeam = (PartyTeam)team;
        if (!partyTeam.getRankForPlayer(player.getUUID()).isAtLeast(minRank)) {
            throw TeamArgument.CANT_EDIT.create((Object)team.getName());
        }
        return partyTeam;
    }

    private static Team teamArg(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return TeamArgument.get(context, "team");
    }

    private static Team teamArg(CommandContext<CommandSourceStack> context, Predicate<Team> predicate) throws CommandSyntaxException {
        Team team = FTBTeamsCommands.teamArg(context);
        if (!predicate.test(team)) {
            throw TeamArgument.TEAM_NOT_FOUND.create((Object)team.getName());
        }
        return team;
    }

    private static ServerTeam serverTeamArg(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return (ServerTeam)FTBTeamsCommands.teamArg(context, Team::isServerTeam);
    }

    private static PartyTeam partyTeamArg(CommandContext<CommandSourceStack> context, TeamRank rank) throws CommandSyntaxException {
        PartyTeam team = (PartyTeam)FTBTeamsCommands.teamArg(context, Team::isPartyTeam);
        if (rank != TeamRank.NONE && !team.getRankForPlayer(((CommandSourceStack)context.getSource()).getPlayerOrException().getUUID()).isAtLeast(rank)) {
            throw TeamArgument.NOT_INVITED.create((Object)team.getName());
        }
        return team;
    }

    private static int tryCreateParty(CommandSourceStack source, String partyName) throws CommandSyntaxException {
        if (FTBTeamsAPIImpl.INSTANCE.isPartyCreationFromAPIOnly()) {
            throw TeamArgument.API_OVERRIDE.create();
        }
        return (Integer)TeamManagerImpl.INSTANCE.createParty(source.getPlayerOrException(), partyName).getLeft();
    }

    private static int info(CommandSourceStack source, Team team) {
        team.getTeamInfo().forEach(line -> source.sendSuccess(() -> line, false));
        ((Consumer)TeamEvent.INFO.invoker()).accept(new TeamInfoEvent(team, source));
        return 1;
    }

    private static int serverId(CommandSourceStack source) {
        UUID managerId = FTBTeamsAPI.api().getManager().getId();
        source.sendSuccess(() -> Component.literal((String)"Server ID: ").append((Component)FTBTUtils.makeCopyableComponent(managerId.toString()).withStyle(ChatFormatting.YELLOW)), false);
        return 1;
    }

    private int list(CommandSourceStack source, Predicate<Team> predicate) {
        Component teams = FTBTeamsAPI.api().getManager().getTeams().stream().filter(predicate).sorted(Comparator.comparing(Team::getShortName)).map(Team::getName).reduce((c1, c2) -> c1.copy().append(", ").append(c2)).orElse((Component)Component.literal((String)"<none>"));
        source.sendSuccess(() -> Component.translatable((String)"ftbteams.list", (Object[])new Object[]{teams}), false);
        return 1;
    }

    private static int redirectChatToggle(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        TeamManager mgr;
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        mgr.setChatRedirected(player, !(mgr = FTBTeamsAPI.api().getManager()).isChatRedirected(player));
        String key = "ftbteams.message.chat_redirected." + (mgr.isChatRedirected(player) ? "on" : "off");
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)key).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GOLD}), false);
        return 1;
    }

    private static int forceAddPlayers(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        int res = 0;
        PartyTeam party = FTBTeamsCommands.partyTeamArg(ctx, TeamRank.NONE);
        for (GameProfile profile : GameProfileArgument.getGameProfiles(ctx, (String)"players")) {
            res += party.join(null, profile);
        }
        return res;
    }

    private static int forceRemovePlayers(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return FTBTeamsCommands.partyTeamArg(ctx, TeamRank.NONE).kick((CommandSourceStack)ctx.getSource(), GameProfileArgument.getGameProfiles(ctx, (String)"players"));
    }

    private int addFakePlayer(Collection<GameProfile> profiles) {
        for (GameProfile profile : profiles) {
            TeamManagerImpl.INSTANCE.playerLoggedIn(null, profile.getId(), profile.getName());
        }
        return 1;
    }

    private int editPlayerTeamNBT(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return FTBTeamsCommands.doTeamEdit(ctx, ((CommandSourceStack)ctx.getSource()).getPlayerOrException(), FTBTeamsCommands.getTeam(ctx));
    }

    private static int editTeamNBT(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return FTBTeamsCommands.doTeamEdit(ctx, ((CommandSourceStack)ctx.getSource()).getPlayerOrException(), TeamArgument.get(ctx, "team"));
    }

    private static int doTeamEdit(CommandContext<CommandSourceStack> ctx, ServerPlayer editor, Team team) {
        if (team instanceof AbstractTeam) {
            AbstractTeam abstractTeam = (AbstractTeam)team;
            CompoundTag info = (CompoundTag)Util.make((Object)new CompoundTag(), t -> {
                t.putString("title", Component.Serializer.toJson((Component)abstractTeam.getColoredName(), (HolderLookup.Provider)editor.registryAccess()));
                t.putString("type", "ftbteams:team");
                t.putUUID("id", team.getTeamId());
                t.putString("team_type", abstractTeam.getType().getSerializedName());
                t.put("text", (Tag)FTBLibraryCommands.InfoBuilder.create((CommandContext)ctx).add("Team Type", (Component)Component.translatable((String)team.getTypeTranslationKey())).add("Owner", (Component)Component.literal((String)team.getOwner().toString())).add("Members", (Component)Component.literal((String)String.valueOf(team.getMembers().size()))).build());
            });
            SNBTCompoundTag tag = abstractTeam.serializeNBT((HolderLookup.Provider)((CommandSourceStack)ctx.getSource()).getServer().registryAccess());
            NetworkHelper.sendTo((ServerPlayer)editor, (CustomPacketPayload)new EditNBTPacket(info, (CompoundTag)tag));
            return 1;
        }
        return 0;
    }
}

