/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.hud;

import immersive_aircraft.client.OverlayRenderer;
import immersive_aircraft.client.hud.Colors;
import immersive_aircraft.client.hud.Indicator;
import immersive_aircraft.client.hud.StringDrawer;
import immersive_aircraft.entity.EngineVehicle;
import java.util.PrimitiveIterator;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class AzimuthIndicator
implements Indicator {
    public static final AzimuthIndicator INSTANCE = new AzimuthIndicator();
    private double lastAz = 0.0;
    private boolean miniHUD = false;

    @Override
    public void update(Minecraft client, EngineVehicle aircraft) {
        this.lastAz = aircraft.getYRot();
    }

    @Override
    public void drawDashboard(GuiGraphics context, Minecraft client, int baseX, int baseY, EngineVehicle aircraft, int color) {
        this.miniHUD = true;
        this.drawHUD(context, client, baseX, baseY + 9, 100, aircraft, color, null);
        this.miniHUD = false;
    }

    @Override
    public void drawHUD(GuiGraphics context, Minecraft client, int baseX, int baseY, int width, EngineVehicle aircraft, int color, int[] edge) {
        double az;
        for (az = this.lastAz; az < 0.0; az += 360.0) {
        }
        while (az >= 360.0) {
            az -= 360.0;
        }
        if (this.miniHUD) {
            StringDrawer.drawString8(context, client, "\u25bd", baseX + 1, baseY - 6, color, this.miniHUD);
        } else if (this.edgeCheck(edge, 5, baseX, baseY + 2)) {
            StringDrawer.drawString2(context, client, "\u25b3", baseX + 1, baseY - 1, color, this.miniHUD);
        }
        int iz = (int)az;
        int nearest1_5 = Math.floorDiv(iz, 5);
        PrimitiveIterator.OfInt it = IntStream.range(nearest1_5 - 9, nearest1_5 + 10).iterator();
        while (it.hasNext()) {
            int xx;
            String vp;
            int v = (Integer)it.next();
            int vl = v < 0 ? v + 72 : v;
            switch (vl) {
                case 0: 
                case 72: {
                    String string = "S";
                    break;
                }
                case 9: {
                    String string = "SW";
                    break;
                }
                case 18: {
                    String string = "W";
                    break;
                }
                case 27: {
                    String string = "NW";
                    break;
                }
                case 36: {
                    String string = "N";
                    break;
                }
                case 45: {
                    String string = "NE";
                    break;
                }
                case 54: {
                    String string = "E";
                    break;
                }
                case 63: {
                    String string = "SE";
                    break;
                }
                default: {
                    String string = vp = (vl & 1) == 0 ? "|" : "\u16e7";
                }
            }
            if (width < 200) {
                switch (vl) {
                    case 8: 
                    case 10: {
                        String string;
                        if (nearest1_5 > 0 && nearest1_5 <= 18) {
                            string = "";
                            break;
                        }
                        string = vp;
                        break;
                    }
                    case 26: 
                    case 28: {
                        String string;
                        if (nearest1_5 > 18 && nearest1_5 <= 36) {
                            string = "";
                            break;
                        }
                        string = vp;
                        break;
                    }
                    case 44: 
                    case 46: {
                        String string;
                        if (nearest1_5 > 36 && nearest1_5 <= 54) {
                            string = "";
                            break;
                        }
                        string = vp;
                        break;
                    }
                    case 62: 
                    case 64: {
                        String string;
                        if (nearest1_5 > 54 && nearest1_5 <= 72) {
                            string = "";
                            break;
                        }
                        string = vp;
                        break;
                    }
                    default: {
                        String string = vp = vp;
                    }
                }
            }
            if (width < 100) {
                switch (vl) {
                    case 17: 
                    case 19: {
                        String string;
                        if (nearest1_5 > 9 && nearest1_5 <= 27) {
                            string = "";
                            break;
                        }
                        string = vp;
                        break;
                    }
                    case 35: 
                    case 37: {
                        String string;
                        if (nearest1_5 > 27 && nearest1_5 <= 45) {
                            string = "";
                            break;
                        }
                        string = vp;
                        break;
                    }
                    case 53: 
                    case 55: {
                        String string;
                        if (nearest1_5 > 45 && nearest1_5 <= 63) {
                            string = "";
                            break;
                        }
                        string = vp;
                        break;
                    }
                    case 1: 
                    case 71: {
                        String string;
                        if (nearest1_5 > 63 || nearest1_5 <= 9) {
                            string = "";
                            break;
                        }
                        string = vp;
                        break;
                    }
                    default: {
                        String string = vp = vp;
                    }
                }
            }
            if (!this.edgeCheck(edge, 5, xx = baseX - (iz - v * 5) * width / 100, baseY)) continue;
            StringDrawer.drawString8(context, client, vp, xx, baseY, color, this.miniHUD);
        }
    }

    @Override
    public void drawDials(GuiGraphics context, Minecraft client, int baseX, int baseY, int scale, EngineVehicle aircraft) {
        double az;
        for (az = this.lastAz; az < 0.0; az += 360.0) {
        }
        while (az >= 360.0) {
            az -= 360.0;
        }
        scale = Math.min(scale, 2);
        context.fill(baseX - 54 * scale, baseY - 9 * scale, baseX + 54 * scale + 1, baseY + 9 + 1, Colors.colorBG);
        int iz = (int)az;
        int[] edge = new int[]{baseY - 7, baseY + 7, baseX - 52 * scale, baseX + 52 * scale};
        int nearest1_5 = Math.floorDiv(iz, 5);
        PrimitiveIterator.OfInt it = IntStream.range(nearest1_5 - 9, nearest1_5 + 10).iterator();
        while (it.hasNext()) {
            int xx;
            String vp;
            int v = (Integer)it.next();
            int vl = v < 0 ? v + 72 : v;
            switch (vl) {
                case 0: 
                case 72: {
                    String string = "S";
                    break;
                }
                case 9: {
                    String string = "SW";
                    break;
                }
                case 18: {
                    String string = "W";
                    break;
                }
                case 27: {
                    String string = "NW";
                    break;
                }
                case 36: {
                    String string = "N";
                    break;
                }
                case 45: {
                    String string = "NE";
                    break;
                }
                case 54: {
                    String string = "E";
                    break;
                }
                case 63: {
                    String string = "SE";
                    break;
                }
                default: {
                    String string = vp = (vl & 1) == 0 ? "|" : "\u16e7";
                }
            }
            if (scale < 2) {
                switch (vl) {
                    case 8: 
                    case 10: {
                        String string;
                        if (nearest1_5 > 0 && nearest1_5 <= 18) {
                            string = "";
                            break;
                        }
                        string = vp;
                        break;
                    }
                    case 26: 
                    case 28: {
                        String string;
                        if (nearest1_5 > 18 && nearest1_5 <= 36) {
                            string = "";
                            break;
                        }
                        string = vp;
                        break;
                    }
                    case 44: 
                    case 46: {
                        String string;
                        if (nearest1_5 > 36 && nearest1_5 <= 54) {
                            string = "";
                            break;
                        }
                        string = vp;
                        break;
                    }
                    case 62: 
                    case 64: {
                        String string;
                        if (nearest1_5 > 54 && nearest1_5 <= 72) {
                            string = "";
                            break;
                        }
                        string = vp;
                        break;
                    }
                    default: {
                        String string = vp = vp;
                    }
                }
            }
            if (!this.edgeCheck(edge, 5, xx = baseX - (iz - v * 5) * scale, baseY)) continue;
            StringDrawer.drawString5(context, client, vp, xx, baseY, Colors.colorFG, this.miniHUD);
        }
        context.fill(baseX - 54 * scale, baseY - 9 * scale, baseX + 54 * scale + 1, baseY - 5 * scale + 1, Colors.colorBG);
        context.fill(baseX - 54 * scale, baseY - 9 * scale, baseX - 42 * scale + 1, baseY + 9 * scale + 1, Colors.colorBG);
        context.fill(baseX + 42 * scale, baseY - 9 * scale, baseX + 54 * scale + 1, baseY + 9 * scale + 1, Colors.colorBG);
        context.fill(baseX - 54 * scale, baseY + 5 * scale, baseX + 54 * scale + 1, baseY + 9 * scale + 1, Colors.colorBG);
        context.fill(baseX - 54 * scale, baseY - 9 * scale, baseX + 54 * scale + 1, baseY - 7 * scale, Colors.colorFG);
        context.fill(baseX - 54 * scale, baseY - 9 * scale, baseX - 52 * scale, baseY + 9 * scale + 1, Colors.colorFG);
        context.fill(baseX - 54 * scale, baseY + 7 * scale + 1, baseX + 54 * scale + 1, baseY + 9 * scale + 1, Colors.colorFG);
        context.fill(baseX + 52 * scale + 1, baseY - 9 * scale, baseX + 54 * scale + 1, baseY + 9 * scale + 1, Colors.colorFG);
        OverlayRenderer.drawScrew(context, baseX - 49 * scale, baseY, scale, true, Colors.colorFG);
        OverlayRenderer.drawScrew(context, baseX + 49 * scale, baseY, scale, false, Colors.colorFG);
        context.fill(baseX - 41 * scale, baseY - 4 * scale, baseX + 41 * scale + 1, baseY - 3 * scale, Colors.colorSD);
        context.fill(baseX - 41 * scale, baseY - 4 * scale, baseX - 40 * scale, baseY + 4 * scale + 1, Colors.colorSD);
        context.fill(baseX - 42 * scale, baseY - 5 * scale, baseX + 42 * scale + 1, baseY - 4 * scale, Colors.colorFG);
        context.fill(baseX - 42 * scale, baseY - 5 * scale, baseX - 41 * scale, baseY + 5 * scale + 1, Colors.colorFG);
        context.fill(baseX - 42 * scale, baseY + 4 * scale + 1, baseX + 42 * scale + 1, baseY + 5 * scale + 1, Colors.colorFG);
        context.fill(baseX + 41 * scale + 1, baseY - 5 * scale, baseX + 42 * scale + 1, baseY + 5 * scale + 1, Colors.colorFG);
        OverlayRenderer.renderLine(context, baseX, baseY - 5 * scale, baseX, baseY + 5 * scale, Colors.colorHD1, false, true);
        StringDrawer.drawString8(context, client, "\u23f7", baseX + 2, baseY - 6 * scale + 7, Colors.colorHD1, false);
        StringDrawer.drawString2(context, client, "\u23f6", baseX + 2, baseY + 6 * scale - 6, Colors.colorHD1, false);
        if (scale > 1) {
            StringDrawer.drawString9(context, client, "AI", baseX + 50 * scale + 1, baseY + 7 * scale + 1, Colors.colorFG, false);
        } else {
            int x = baseX + 43;
            int y = baseY + 8;
            context.fill(x, y - 5, x + 1, y, Colors.colorFG);
            context.fill(x + 2, y - 5, x + 3, y, Colors.colorFG);
            context.fill(x + 1, y - 3, x + 2, y - 2, Colors.colorFG);
            x = baseX + 46;
            y = baseY + 8;
            context.fill(x + 1, y - 5, x + 2, y, Colors.colorFG);
        }
    }
}

