/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import cpw.mods.inventorysorter.Action;
import cpw.mods.inventorysorter.ServerHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

public final class Network {
    static void registerPayloadHandlers(IEventBus bus) {
        bus.addListener(Network::registerPayloadHandler);
    }

    private static void registerPayloadHandler(RegisterPayloadHandlersEvent evt) {
        PayloadRegistrar registrar = evt.registrar("inventorysorter").versioned("1");
        registrar.playToServer(ActionMessage.TYPE, ActionMessage.CODEC, ServerHandler::onMessage);
    }

    public static class ActionMessage
    implements CustomPacketPayload {
        static final CustomPacketPayload.Type<ActionMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"inventorysorter", (String)"action_message"));
        static final StreamCodec<FriendlyByteBuf, ActionMessage> CODEC = CustomPacketPayload.codec(ActionMessage::write, ActionMessage::read);
        Action action;
        int slotIndex;

        ActionMessage(Action action, int slotIndex) {
            this.action = action;
            this.slotIndex = slotIndex;
        }

        private void write(FriendlyByteBuf buf) {
            buf.writeByte(this.action.ordinal());
            buf.writeInt(this.slotIndex);
        }

        static ActionMessage read(ByteBuf buf) {
            return new ActionMessage(Action.values()[buf.readByte()], buf.readInt());
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

