/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.custom;

import com.mojang.datafixers.util.Pair;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.block.BlockRenderType;
import dev.latvian.mods.kubejs.block.RandomTickCallbackJS;
import dev.latvian.mods.kubejs.block.SeedItemBuilder;
import dev.latvian.mods.kubejs.block.custom.BasicCropBlockJS;
import dev.latvian.mods.kubejs.client.ModelGenerator;
import dev.latvian.mods.kubejs.client.VariantBlockStateGenerator;
import dev.latvian.mods.kubejs.generator.KubeAssetGenerator;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.rhino.util.ReturnsSelf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

@ReturnsSelf
public class CropBlockBuilder
extends BlockBuilder {
    public static final ResourceLocation[] CROP_BLOCK_TAGS = new ResourceLocation[]{BlockTags.CROPS.location()};
    public static final ResourceLocation[] CROP_ITEM_TAGS = new ResourceLocation[]{Tags.Items.SEEDS.location()};
    private static final ResourceLocation MODEL = ResourceLocation.withDefaultNamespace((String)"block/crop");
    public transient int age = 7;
    protected transient List<VoxelShape> shapeByAge = Collections.nCopies(8, Shapes.block());
    public transient ToDoubleFunction<RandomTickCallbackJS> growSpeedCallback = null;
    public transient ToIntFunction<RandomTickCallbackJS> fertilizerCallback = null;
    public transient SurviveCallback surviveCallback = null;
    public transient List<Pair<Item, NumberProvider>> outputs;

    public CropBlockBuilder(ResourceLocation id) {
        super(id);
        this.renderType = BlockRenderType.CUTOUT;
        this.noCollision = true;
        this.itemBuilder = new SeedItemBuilder(this.newID("", "_seeds"));
        ((SeedItemBuilder)this.itemBuilder).blockBuilder = this;
        this.hardness = 0.0f;
        this.resistance = 0.0f;
        this.outputs = new ArrayList<Pair<Item, NumberProvider>>();
        this.notSolid = true;
        this.soundType(SoundType.CROP);
        this.mapColor(MapColor.PLANT);
        for (int a = 0; a <= this.age; ++a) {
            this.textures.put(String.valueOf(a), this.newID("block/", "/" + a).toString());
        }
        this.tagBlock(CROP_BLOCK_TAGS);
        this.tagItem(CROP_ITEM_TAGS);
    }

    @Override
    public BlockBuilder noItem() {
        this.itemBuilder = null;
        return this;
    }

    @Info(value="Add a crop output with exactly one output.")
    public CropBlockBuilder crop(Item output) {
        this.crop(output, (NumberProvider)ConstantValue.exactly((float)1.0f));
        return this;
    }

    @Info(value="Add a crop output with a specific amount.")
    public CropBlockBuilder crop(Item output, NumberProvider chance) {
        this.outputs.add((Pair<Item, NumberProvider>)new Pair((Object)output, (Object)chance));
        return this;
    }

    @Info(value="Set the age of the crop. Note that the box will be the same for all ages (A full block size).")
    public CropBlockBuilder age(int age) {
        this.age(age, builder -> {});
        return this;
    }

    @Info(value="Set the age of the crop and the shape of the crop at that age.")
    public CropBlockBuilder age(int age, Consumer<ShapeBuilder> builder) {
        this.age = age;
        ShapeBuilder shapes = new ShapeBuilder(age);
        builder.accept(shapes);
        this.shapeByAge = shapes.getShapes();
        this.textures.clear();
        for (int i = 0; i <= age; ++i) {
            this.textures.put(String.valueOf(i), this.newID("block/", "/" + i).toString());
        }
        return this;
    }

    public CropBlockBuilder farmersCanPlant() {
        this.tagItem(new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"villager_plantable_seeds")});
        return this;
    }

    public CropBlockBuilder bonemeal(ToIntFunction<RandomTickCallbackJS> bonemealCallback) {
        this.fertilizerCallback = bonemealCallback;
        return this;
    }

    public CropBlockBuilder survive(SurviveCallback surviveCallback) {
        this.surviveCallback = surviveCallback;
        return this;
    }

    public CropBlockBuilder growTick(ToDoubleFunction<RandomTickCallbackJS> growSpeedCallback) {
        this.growSpeedCallback = growSpeedCallback;
        return this;
    }

    @Override
    public BlockBuilder randomTick(@Nullable Consumer<RandomTickCallbackJS> randomTickCallback) {
        KubeJS.LOGGER.warn("randomTick is overridden by growTick to return grow speed, use it instead.");
        return this;
    }

    @Override
    @Nullable
    public LootTable generateLootTable() {
        LootItemBlockStatePropertyCondition.Builder mature = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)this.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CropBlock.AGE, this.age));
        LootTable.Builder builder = LootTable.lootTable();
        for (Pair<Item, NumberProvider> output : this.outputs) {
            LootPoolSingletonContainer.Builder cropItem = (LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)output.getFirst())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)((NumberProvider)output.getSecond()))).when((LootItemCondition.Builder)mature);
            builder.withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)cropItem));
        }
        if (this.itemBuilder != null) {
            LootPool.Builder pool = LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)this.itemBuilder.get())).when((LootItemCondition.Builder)mature)).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)this.itemBuilder.get()))));
            builder.withPool(pool);
        }
        return builder.build();
    }

    @Override
    protected void generateBlockState(VariantBlockStateGenerator bs) {
        for (int i = 0; i <= this.age; ++i) {
            bs.simpleVariant("age=" + i, this.parentModel == null ? this.id.withPath("block/" + this.id.getPath() + "/" + i) : this.parentModel);
        }
    }

    @Override
    protected void generateBlockModels(KubeAssetGenerator generator) {
        for (int i = 0; i <= this.age; ++i) {
            int fi = i;
            generator.blockModel(this.newID("", "/" + i), m -> {
                m.parent(MODEL);
                m.texture("crop", (String)this.textures.get(String.valueOf(fi)));
            });
        }
    }

    @Override
    protected void generateItemModel(ModelGenerator m) {
        m.parent(KubeAssetGenerator.GENERATED_ITEM_MODEL);
        m.texture("layer0", this.itemBuilder.baseTexture);
    }

    @Override
    public Block createObject() {
        return new BasicCropBlockJS(this);
    }

    @FunctionalInterface
    public static interface SurviveCallback {
        public boolean survive(BlockState var1, LevelReader var2, BlockPos var3);
    }

    public static class ShapeBuilder {
        private final List<VoxelShape> shapes;

        public ShapeBuilder(int age) {
            this.shapes = new ArrayList<VoxelShape>(Collections.nCopies(age + 1, Shapes.block()));
        }

        @Info(value="Describe the shape of the crop at a specific age.\n\nmin/max coordinates are double values between 0 and 16.\n")
        public ShapeBuilder shape(int age, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            this.shapes.set(age, Block.box((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
            return this;
        }

        @Info(value="Makes the block to have a box like wheat for each stage.")
        public ShapeBuilder wheat() {
            this.shapes.clear();
            for (int i = 0; i < 8; ++i) {
                this.shapes.add(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)(2 + i * 2), (double)16.0));
            }
            return this;
        }

        @Info(value="Makes the block to have a box like carrot for each stage.")
        public ShapeBuilder carrot() {
            this.shapes.clear();
            for (int i = 0; i < 8; ++i) {
                this.shapes.add(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)(2 + i), (double)16.0));
            }
            return this;
        }

        @Info(value="Makes the block to have a box like beetroot for each stage.")
        public ShapeBuilder beetroot() {
            this.shapes.clear();
            for (int i = 0; i < 4; ++i) {
                this.shapes.add(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)(2 + i * 2), (double)16.0));
            }
            return this;
        }

        @Info(value="Makes the block to have a box like potato for each stage.")
        public ShapeBuilder potato() {
            return this.carrot();
        }

        public List<VoxelShape> getShapes() {
            return List.copyOf(this.shapes);
        }
    }
}

