/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import dev.latvian.mods.kubejs.recipe.RecipesKubeEvent;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Nullable;

public interface RecipeHelper {
    @Nullable
    public static RecipeHolder<?> fromJson(DynamicOps<JsonElement> ops, RecipeSerializer<?> serializer, ResourceLocation id, JsonObject json, boolean errors) {
        MapCodec codec = serializer.codec();
        if (codec == null) {
            if (errors) {
                ConsoleJS.SERVER.error("Error parsing recipe " + String.valueOf(id) + ": Codec not found in " + serializer.getClass().getName());
            } else {
                RecipeManager.LOGGER.error("Error parsing recipe " + String.valueOf(id) + ": Codec not found in " + serializer.getClass().getName());
            }
            return null;
        }
        Optional map = ops.getMap((Object)json).result();
        if (map.isEmpty()) {
            if (errors) {
                ConsoleJS.SERVER.error("Error parsing recipe " + String.valueOf(id) + ": Couldn't convert " + String.valueOf(json) + " to a map");
            } else {
                RecipeManager.LOGGER.error("Error parsing recipe " + String.valueOf(id) + ": Couldn't convert " + String.valueOf(json) + " to a map");
            }
            return null;
        }
        try {
            DataResult recipe = codec.decode(ops, (MapLike)map.get());
            if (recipe.isSuccess()) {
                Recipe r = (Recipe)recipe.getOrThrow();
                return r == null ? null : new RecipeHolder(id, r);
            }
            if (recipe.error().isPresent()) {
                if (errors) {
                    ConsoleJS.SERVER.error("Error parsing recipe " + String.valueOf(id) + ": " + ((DataResult.Error)recipe.error().get()).message());
                } else {
                    RecipeManager.LOGGER.error("Error parsing recipe " + String.valueOf(id) + ": " + ((DataResult.Error)recipe.error().get()).message());
                }
            } else if (errors) {
                ConsoleJS.SERVER.error("Error parsing recipe " + String.valueOf(id) + ": Unknown");
            } else {
                RecipeManager.LOGGER.error("Error parsing recipe " + String.valueOf(id) + ": Unknown");
            }
        }
        catch (Exception e) {
            if (errors) {
                ConsoleJS.SERVER.error("Error parsing recipe " + String.valueOf(id) + " from " + String.valueOf(map.get()), e, RecipesKubeEvent.CREATE_RECIPE_SKIP_ERROR);
            }
            RecipeManager.LOGGER.error("Error parsing recipe " + String.valueOf(id) + " from " + String.valueOf(map.get()), (Throwable)e);
        }
        return null;
    }
}

