/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import dev.latvian.mods.kubejs.error.EmptyRecipeComponentException;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.JSObjectTypeInfo;
import dev.latvian.mods.rhino.type.JSOptionalParam;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RecipeComponentBuilder
implements RecipeComponent<Map<Key, Value>> {
    public final List<Key> keys;
    public Predicate<Set<String>> hasPriority;

    public RecipeComponentBuilder(List<Key> keys) {
        this.keys = List.copyOf(keys);
    }

    public RecipeComponentBuilder hasPriority(Predicate<Set<String>> hasPriority) {
        this.hasPriority = hasPriority;
        return this;
    }

    public RecipeComponentBuilder createCopy() {
        RecipeComponentBuilder copy = new RecipeComponentBuilder(this.keys);
        copy.hasPriority = this.hasPriority;
        return copy;
    }

    public MapCodec<Map<Key, Value>> mapCodec() {
        return new MapCodec<Map<Key, Value>>(){

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return RecipeComponentBuilder.this.keys.stream().map(Key::name).map(arg_0 -> ops.createString(arg_0));
            }

            public <T> DataResult<Map<Key, Value>> decode(DynamicOps<T> ops, MapLike<T> input) {
                HashMap map = new HashMap(RecipeComponentBuilder.this.keys.size());
                HashMap keyMap = new HashMap();
                RecipeComponentBuilder.this.keys.forEach(key -> keyMap.put(key.name, key));
                input.entries().forEach(entry -> {
                    Key key = (Key)keyMap.get(ops.getStringValue(entry.getFirst()).getOrThrow());
                    if (key != null) {
                        map.put(key, new Value(key, RecipeComponentBuilder.this.keys.indexOf(key), key.component.codec().decode(ops, entry.getSecond())));
                    }
                });
                return DataResult.success(map);
            }

            public <T> RecordBuilder<T> encode(Map<Key, Value> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                RecordBuilder builder = ops.mapBuilder();
                for (Value entry : input.values()) {
                    builder.add(ops.createString(entry.key.name), entry.key.component.codec().encodeStart(ops, Cast.to(entry.value)));
                }
                return builder;
            }
        };
    }

    @Override
    public Codec<Map<Key, Value>> codec() {
        return this.mapCodec().codec();
    }

    @Override
    public TypeInfo typeInfo() {
        ArrayList<JSOptionalParam> list = new ArrayList<JSOptionalParam>(this.keys.size());
        for (Key key : this.keys) {
            list.add(new JSOptionalParam(key.name, key.component.typeInfo(), key.optional()));
        }
        return new JSObjectTypeInfo(list);
    }

    @Override
    public boolean hasPriority(Context cx, KubeRecipe recipe, Object from) {
        if (from instanceof Map) {
            Map m = (Map)from;
            if (this.hasPriority != null) {
                return this.hasPriority.test(m.keySet());
            }
            for (Key key : this.keys) {
                if (key.optional() || m.containsKey(key.name)) continue;
                return false;
            }
            return true;
        }
        if (from instanceof JsonObject) {
            JsonObject json = (JsonObject)from;
            if (this.hasPriority != null) {
                return this.hasPriority.test(json.keySet());
            }
            for (Key key : this.keys) {
                if (key.optional() || json.has(key.name)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(Context cx, KubeRecipe recipe, Map<Key, Value> value, ReplacementMatchInfo match) {
        for (Value e : value.values()) {
            if (!e.key.component.matches(cx, recipe, Cast.to(e.value), match)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<Key, Value> replace(Context cx, KubeRecipe recipe, Map<Key, Value> original, ReplacementMatchInfo match, Object with) {
        Map<Key, Value> replaced = original;
        for (Value e : original.values()) {
            Object r = e.key.component.replace(cx, recipe, Cast.to(e.value), match, with);
            if (r == e.value) continue;
            if (replaced == original) {
                replaced = new LinkedHashMap<Key, Value>(original);
            }
            replaced.put(e.key, new Value(e.key, e.index, r));
        }
        return replaced;
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, Map<Key, Value> map) {
        boolean first = true;
        for (Value value : map.values()) {
            if (value.value == null) continue;
            if (first) {
                first = false;
            } else {
                builder.appendSeparator();
            }
            value.key.component.buildUniqueId(builder, Cast.to(value.value));
        }
    }

    @Override
    public void validate(Map<Key, Value> value) {
        if (value.isEmpty()) {
            throw new EmptyRecipeComponentException(this);
        }
        for (Value entry : value.values()) {
            entry.key.component.validate(Cast.to(entry.value));
        }
    }

    @Override
    public boolean isEmpty(Map<Key, Value> value) {
        if (this.keys.isEmpty()) {
            return true;
        }
        for (Value entry : value.values()) {
            if (!entry.key.component.isEmpty(Cast.to(entry.value))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.keys.stream().map(Key::toString).collect(Collectors.joining(", ", "{", "}"));
    }

    public record Key(String name, RecipeComponent<?> component, boolean optional, boolean alwaysWrite) {
        public Key(String name, RecipeComponent<?> component, boolean optional) {
            this(name, component, optional, false);
        }

        public Key(String name, RecipeComponent<?> component) {
            this(name, component, false);
        }

        @Override
        public String toString() {
            return this.name + (this.optional ? "?" : "") + (this.alwaysWrite ? "!" : "") + ": " + String.valueOf(this.component);
        }
    }

    public record Value(Key key, int index, Object value) implements Map.Entry<Key, Object>
    {
        @Override
        public Key getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }
    }
}

