/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.Lithostitched;
import dev.worldgen.lithostitched.worldgen.processor.ReferenceStructureProcessor;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;

public class UnboundReferenceProcessor
extends StructureProcessor {
    public static final MapCodec<UnboundReferenceProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("name").forGetter(UnboundReferenceProcessor::name)).apply((Applicative)instance, UnboundReferenceProcessor::new));
    public static final StructureProcessorType<UnboundReferenceProcessor> TYPE = () -> CODEC;
    private final ResourceLocation name;

    private UnboundReferenceProcessor(ResourceLocation name) {
        this.name = name;
    }

    public static UnboundReferenceProcessor of(String name) {
        return new UnboundReferenceProcessor(Lithostitched.id(name));
    }

    public ResourceLocation name() {
        return this.name;
    }

    public ReferenceStructureProcessor bind(ServerLevel level) {
        Optional set = level.registryAccess().lookupOrThrow(Registries.PROCESSOR_LIST).get(ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)this.name));
        return new ReferenceStructureProcessor((HolderSet<StructureProcessorList>)(set.isPresent() ? HolderSet.direct((Holder[])new Holder[]{(Holder)set.get()}) : HolderSet.empty()));
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos blockPos, BlockPos blockPos2, StructureTemplate.StructureBlockInfo structureBlockInfo, StructureTemplate.StructureBlockInfo currentBlockInfo, StructurePlaceSettings structurePlaceSettings) {
        throw new IllegalStateException("[Lithostitched] Unbound reference structure processor should never be processed!");
    }

    @NotNull
    protected StructureProcessorType<?> getType() {
        return TYPE;
    }
}

