/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.mechanical_botany.kinetics.insolator;

import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dakotapride.mechanical_botany.ModConfigs;
import net.dakotapride.mechanical_botany.ModRecipeTypes;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
public class InsolatingRecipe
extends StandardProcessingRecipe<RecipeInput> {
    public InsolatingRecipe(ProcessingRecipeParams params) {
        super(ModRecipeTypes.INSOLATING, params);
    }

    public FluidIngredient getRequiredFluid() {
        return (FluidIngredient)this.fluidIngredients.get(0);
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxFluidInputCount() {
        return 1;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public int getProcessingDuration() {
        return super.getProcessingDuration() * (Integer)ModConfigs.server().insolator.processingTimeMultiplier.get();
    }

    public boolean matches(RecipeInput inv, Level worldIn) {
        if (inv.isEmpty()) {
            return false;
        }
        return ((Ingredient)this.ingredients.get(0)).test(inv.getItem(0)) && ((FluidIngredient)this.fluidIngredients.get(0)).test((FluidStack)this.getRequiredFluid().getMatchingFluidStacks().get(0));
    }

    protected int getMaxOutputCount() {
        return 4;
    }

    public static class Serializer
    extends StandardProcessingRecipe.Serializer<InsolatingRecipe> {
        public Serializer() {
            super(InsolatingRecipe::new);
        }
    }
}

