/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanicals.compat.jade;

import com.oierbravo.mechanicals.compat.jade.IHavePercent;
import com.oierbravo.mechanicals.utility.LibLang;
import java.awt.Color;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ProgressStyle;

public class MechanicalProgressComponentProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    private final ResourceLocation UID;

    public MechanicalProgressComponentProvider(ResourceLocation UID) {
        this.UID = UID;
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        int progress;
        if (accessor.getServerData().contains("progress") && (progress = accessor.getServerData().getInt("progress")) > 0) {
            IElementHelper helper = IElementHelper.get();
            ProgressStyle progressStyle = helper.progressStyle().textColor(1);
            tooltip.add(helper.progress((float)progress / 100.0f, (Component)LibLang.translate("ui.progress", progress).component().withColor(Color.GRAY.getRGB()), progressStyle.color(Color.YELLOW.getRGB()), (BoxStyle)BoxStyle.getTransparent(), false));
        }
    }

    public ResourceLocation getUid() {
        return this.UID;
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        if (blockAccessor.getBlockEntity() instanceof IHavePercent) {
            compoundTag.putInt("progress", ((IHavePercent)blockAccessor.getBlockEntity()).getProgressPercent());
        }
    }
}

