/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanicals.foundation.recipe;

import com.mojang.serialization.Codec;
import com.oierbravo.mechanicals.foundation.recipe.RecipeRequirementType;
import com.oierbravo.mechanicals.register.MechanicalRegistries;
import com.oierbravo.mechanicals.utility.LibLang;
import com.oierbravo.mechanicals.utility.MechanicalLangIdGenerator;
import java.util.List;
import net.createmod.catnip.data.Pair;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface IRecipeRequirement {
    public static final Codec<IRecipeRequirement> CODEC = MechanicalRegistries.RECIPE_REQUIREMENT_TYPE.byNameCodec().dispatch(IRecipeRequirement::getType, RecipeRequirementType::codec);
    public static final Codec<List<IRecipeRequirement>> LIST_CODEC = CODEC.listOf();
    public static final StreamCodec<RegistryFriendlyByteBuf, IRecipeRequirement> STREAM_CODEC = ByteBufCodecs.registry(MechanicalRegistries.Keys.RECIPE_REQUIREMENT).dispatch(IRecipeRequirement::getType, RecipeRequirementType::streamCodec);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<IRecipeRequirement>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.list((int)256));

    public boolean test(Level var1, BlockEntity var2);

    public String getIdString();

    public String toString();

    public RecipeRequirementType<?> getType();

    default public Pair<Component, Component> toTooltipComponent() {
        return Pair.of((Object)LibLang.translate(MechanicalLangIdGenerator.recipeRequirement(this.getIdString(), "title"), new Object[0]).component(), (Object)LibLang.translate(MechanicalLangIdGenerator.recipeRequirement(this.getIdString(), "value"), this.toString()).component());
    }

    default public Component toItemTooltipComponent() {
        return LibLang.translate(MechanicalLangIdGenerator.recipeRequirement(this.getIdString(), "title"), new Object[0]).component().append((Component)LibLang.translate(MechanicalLangIdGenerator.recipeRequirement(this.getIdString(), "value"), this.toString()).component());
    }

    default public Component toMissingComponent() {
        return LibLang.translate(MechanicalLangIdGenerator.recipeRequirement(this.getIdString(), "missing"), new Object[0]).component();
    }
}

