/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanicals.utility;

import com.oierbravo.mechanicals.utility.MechanicalLangIdGenerator;
import com.tterrag.registrate.AbstractRegistrate;

public class RegistrateLangBuilder<R extends AbstractRegistrate<?>> {
    private final String namespace;
    private final R registrate;

    public RegistrateLangBuilder(String namespace, R registrate) {
        this.namespace = namespace;
        this.registrate = registrate;
    }

    public RegistrateLangBuilder<R> add(String literal, String defaultTranslation) {
        this.registrate.addRawLang(this.namespace + "." + literal, defaultTranslation);
        return this;
    }

    public RegistrateLangBuilder<R> addCreativeTab(String defaultTranslation) {
        return this.add(MechanicalLangIdGenerator.creativeTabId("main"), defaultTranslation);
    }

    public RegistrateLangBuilder<R> addJade(String defaultTranslation) {
        this.registrate.addRawLang(MechanicalLangIdGenerator.jadeId(this.namespace), defaultTranslation);
        return this;
    }

    public RegistrateLangBuilder<R> addRaw(String literal, String defaultTranslation) {
        this.registrate.addRawLang(literal, defaultTranslation);
        return this;
    }

    protected RegistrateLangBuilder<R> addRecipeRequirement(String variant, String id, String defaultTranslation) {
        this.registrate.addRawLang("mechanicals." + MechanicalLangIdGenerator.recipeRequirement(id, variant), defaultTranslation);
        return this;
    }

    public RegistrateLangBuilder<R> addRecipeRequirementTitle(String id, String defaultTranslation) {
        return this.addRecipeRequirement("title", id, defaultTranslation);
    }

    public RegistrateLangBuilder<R> addRecipeRequirementValue(String id, String defaultTranslation) {
        return this.addRecipeRequirement("value", id, defaultTranslation);
    }

    public RegistrateLangBuilder<R> addRecipeRequirementMissing(String id, String defaultTranslation) {
        return this.addRecipeRequirement("missing", id, defaultTranslation);
    }

    protected RegistrateLangBuilder<R> addTooltip(String id, String type, String variant, String defaultTranslation) {
        this.registrate.addRawLang(type + "." + this.namespace + "." + id + ".tooltip." + variant, defaultTranslation);
        return this;
    }

    public RegistrateLangBuilder<R> addItemTooltip(String id, String variant, String defaultTranslation) {
        return this.addTooltip(id, "item", variant, defaultTranslation);
    }

    public RegistrateLangBuilder<R> addItemTooltipSummary(String id, String defaultTranslation) {
        return this.addItemTooltip(id, "summary", defaultTranslation);
    }

    public RegistrateLangBuilder<R> addItemTooltipCondition(String id, int index, String defaultTranslation) {
        return this.addItemTooltip(id, "condition" + index, defaultTranslation);
    }

    public RegistrateLangBuilder<R> addItemTooltipBehaviour(String id, int index, String defaultTranslation) {
        return this.addItemTooltip(id, "behaviour" + index, defaultTranslation);
    }

    protected RegistrateLangBuilder<R> addBlockTooltip(String id, String variant, String defaultTranslation) {
        return this.addTooltip(id, "block", variant, defaultTranslation);
    }

    public RegistrateLangBuilder<R> addBlockTooltipSummary(String id, String defaultTranslation) {
        return this.addBlockTooltip(id, "summary", defaultTranslation);
    }

    public RegistrateLangBuilder<R> addBlockTooltipCondition(String id, int index, String defaultTranslation) {
        return this.addBlockTooltip(id, "condition" + index, defaultTranslation);
    }

    public RegistrateLangBuilder<R> addBlockTooltipBehaviour(String id, int index, String defaultTranslation) {
        return this.addBlockTooltip(id, "behaviour" + index, defaultTranslation);
    }

    protected RegistrateLangBuilder<R> addPonder(String id, String variant, String defaultTranslation) {
        this.registrate.addRawLang(this.namespace + ".ponder." + id + "." + variant, defaultTranslation);
        return this;
    }

    public RegistrateLangBuilder<R> addPonderHeader(String id, String defaultTranslation) {
        return this.addPonder(id, "header", defaultTranslation);
    }

    public RegistrateLangBuilder<R> addPonderText(int index, String id, String defaultTranslation) {
        return this.addPonder(id, "text_" + index, defaultTranslation);
    }
}

